/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.graalvm.buildtools.Utils;
import org.graalvm.buildtools.maven.NativeExtension;
import org.graalvm.buildtools.utils.NativeImageUtils;

@Mojo(name="merge-agent-files", defaultPhase=LifecyclePhase.TEST)
public class MergeAgentFilesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected String target;
    @Parameter(property="native.agent.merge.context", required=true)
    protected String context;
    @Component
    protected Logger logger;

    public void execute() throws MojoExecutionException {
        String agentOutputDirectory = NativeExtension.agentOutputDirectoryFor(this.target, NativeExtension.Context.valueOf(this.context));
        File baseDir = new File(agentOutputDirectory);
        if (baseDir.exists()) {
            Path nativeImageExecutable = Utils.getNativeImage(this.logger);
            File mergerExecutable = this.tryInstall(nativeImageExecutable);
            List<File> sessionDirectories = MergeAgentFilesMojo.sessionDirectoriesFrom(baseDir.listFiles()).collect(Collectors.toList());
            this.invokeMerge(mergerExecutable, sessionDirectories, baseDir);
        } else {
            this.getLog().debug((CharSequence)("Agent output directory " + baseDir + " doesn't exist. Skipping merge."));
        }
    }

    private File tryInstall(Path nativeImageExecutablePath) {
        File nativeImageExecutable = nativeImageExecutablePath.toAbsolutePath().toFile();
        File mergerExecutable = new File(nativeImageExecutable.getParentFile(), NativeImageUtils.nativeImageConfigureFileName());
        if (!mergerExecutable.exists()) {
            this.getLog().info((CharSequence)("Installing native image merger to " + mergerExecutable));
            ProcessBuilder processBuilder = new ProcessBuilder(nativeImageExecutable.toString());
            processBuilder.command().add("--macro:native-image-configure-launcher");
            processBuilder.directory(mergerExecutable.getParentFile());
            processBuilder.inheritIO();
            try {
                Process installProcess = processBuilder.start();
                if (installProcess.waitFor() != 0) {
                    this.getLog().warn((CharSequence)"Installation of native image merging tool failed");
                }
                NativeImageUtils.maybeCreateConfigureUtilSymlink((File)mergerExecutable, (Path)nativeImageExecutablePath);
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return mergerExecutable;
    }

    private static Stream<File> sessionDirectoriesFrom(File[] files) {
        return Arrays.stream(files).filter(File::isDirectory).filter(f -> f.getName().startsWith("session-"));
    }

    private void invokeMerge(File mergerExecutable, List<File> inputDirectories, File outputDirectory) throws MojoExecutionException {
        if (!mergerExecutable.exists()) {
            this.getLog().warn((CharSequence)"Cannot merge agent files because native-image-configure is not installed. Please upgrade to a newer version of GraalVM.");
            return;
        }
        try {
            if (inputDirectories.isEmpty()) {
                this.getLog().warn((CharSequence)"Skipping merging of agent files since there are no input directories.");
                return;
            }
            this.getLog().info((CharSequence)("Merging agent " + inputDirectories.size() + " files into " + outputDirectory));
            ArrayList<String> args = new ArrayList<String>(inputDirectories.size() + 2);
            args.add("generate");
            inputDirectories.stream().map(f -> "--input-dir=" + f.getAbsolutePath()).forEach(args::add);
            args.add("--output-dir=" + outputDirectory.getAbsolutePath());
            ProcessBuilder processBuilder = new ProcessBuilder(mergerExecutable.toString());
            processBuilder.command().addAll(args);
            processBuilder.inheritIO();
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
            for (File inputDirectory : inputDirectories) {
                FileUtils.deleteDirectory((File)inputDirectory);
            }
            this.getLog().debug((CharSequence)("Agent output: " + Arrays.toString(outputDirectory.listFiles())));
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Merging agent files with " + mergerExecutable + " failed", e);
        }
    }
}

