/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.logging.Logger;
import org.graalvm.buildtools.utils.SharedConstants;

public abstract class Utils
implements SharedConstants {
    public static final String NATIVE_TESTS_EXE = "native-tests" + EXECUTABLE_EXTENSION;
    public static final String MAVEN_GROUP_ID = "org.graalvm.buildtools";
    public static Path nativeImageCache;

    public static Path getJavaHomeNativeImage(String javaHomeVariable, Boolean failFast, Logger logger) throws MojoExecutionException {
        Path graalExe;
        block9: {
            String graalHome = System.getenv(javaHomeVariable);
            if (graalHome == null) {
                return null;
            }
            Path graalHomePath = Paths.get(graalHome, new String[0]);
            graalExe = graalHomePath.resolve("bin").resolve(NATIVE_IMAGE_EXE);
            Path guExe = graalHomePath.resolve("bin").resolve(GU_EXE);
            if (!Files.exists(graalExe, new LinkOption[0])) {
                if (Files.exists(guExe, new LinkOption[0])) {
                    ProcessBuilder processBuilder = new ProcessBuilder(guExe.toString(), "install", "native-image");
                    processBuilder.inheritIO();
                    try {
                        Process nativeImageFetchingProcess = processBuilder.start();
                        if (nativeImageFetchingProcess.waitFor() != 0) {
                            throw new MojoExecutionException("Native Image executable wasn't found, and '" + GU_EXE + "' tool failed to install it.");
                        }
                        break block9;
                    }
                    catch (IOException | InterruptedException | MojoExecutionException e) {
                        throw new MojoExecutionException("Determining GraalVM installation failed with message: " + e.getMessage());
                    }
                }
                if (failFast.booleanValue()) {
                    throw new MojoExecutionException("'" + GU_EXE + "' tool wasn't found. This probably means that JDK at isn't a GraalVM distribution.");
                }
            }
        }
        if (!Files.exists(graalExe, new LinkOption[0])) {
            if (failFast.booleanValue()) {
                throw new RuntimeException("native-image is not installed in your " + javaHomeVariable + ".You should install it using `gu install native-image`");
            }
            return null;
        }
        logger.info("Found GraalVM installation from " + javaHomeVariable + " variable.");
        return graalExe;
    }

    public static Path getNativeImageFromPath() {
        Optional<Path> exePath = Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(x$0 -> Paths.get(x$0, new String[0])).filter(path -> Files.exists(path.resolve(NATIVE_IMAGE_EXE), new LinkOption[0])).findFirst();
        return exePath.map(path -> path.resolve(NATIVE_IMAGE_EXE)).orElse(null);
    }

    public static Path getNativeImage(Logger logger) throws MojoExecutionException {
        if (nativeImageCache != null) {
            return nativeImageCache;
        }
        Path nativeImage = Utils.getJavaHomeNativeImage("GRAALVM_HOME", false, logger);
        if (nativeImage == null) {
            nativeImage = Utils.getJavaHomeNativeImage("JAVA_HOME", true, logger);
        }
        if (nativeImage == null && (nativeImage = Utils.getNativeImageFromPath()) != null) {
            logger.info("Found GraalVM installation from PATH variable.");
        }
        if (nativeImage == null) {
            throw new RuntimeException("GraalVM native-image is missing from your system.\n Make sure that GRAALVM_HOME environment variable is present.");
        }
        nativeImageCache = nativeImage;
        return nativeImage;
    }
}

