/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.graalvm.buildtools.maven.config.MetadataRepositoryConfiguration;
import org.graalvm.buildtools.utils.FileUtils;
import org.graalvm.reachability.DirectoryConfiguration;
import org.graalvm.reachability.GraalVMReachabilityMetadataRepository;
import org.graalvm.reachability.Query;
import org.graalvm.reachability.internal.FileSystemRepository;

public abstract class AbstractNativeMojo
extends AbstractMojo {
    private static final String GROUP_ID = "org.graalvm.buildtools";
    private static final String GRAALVM_REACHABILITY_METADATA_ARTIFACT_ID = "graalvm-reachability-metadata";
    private static final String REPOSITORY_FORMAT = "zip";
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor plugin;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/graalvm-reachability-metadata", required=true)
    protected File reachabilityMetadataOutputDirectory;
    @Parameter(alias="metadataRepository")
    protected MetadataRepositoryConfiguration metadataRepositoryConfiguration;
    protected final Set<DirectoryConfiguration> metadataRepositoryConfigurations = new HashSet<DirectoryConfiguration>();
    protected GraalVMReachabilityMetadataRepository metadataRepository;
    @Component
    protected Logger logger;
    @Component
    protected MavenSession mavenSession;
    @Component
    protected RepositorySystem repositorySystem;

    @Inject
    protected AbstractNativeMojo() {
    }

    protected boolean isMetadataRepositoryEnabled() {
        return this.metadataRepositoryConfiguration != null && this.metadataRepositoryConfiguration.isEnabled();
    }

    protected void configureMetadataRepository() {
        if (this.isMetadataRepositoryEnabled()) {
            Path repoPath = null;
            Path destinationRoot = this.reachabilityMetadataOutputDirectory.toPath();
            if (Files.exists(destinationRoot, new LinkOption[0]) && !Files.isDirectory(destinationRoot, new LinkOption[0])) {
                throw new RuntimeException("Metadata repository must be a directory, please remove regular file at: " + destinationRoot);
            }
            try {
                Files.createDirectories(destinationRoot, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.metadataRepositoryConfiguration.getLocalPath() != null) {
                Path localPath = this.metadataRepositoryConfiguration.getLocalPath().toPath();
                Path destination = destinationRoot.resolve(FileUtils.hashFor((URI)localPath.toUri()));
                repoPath = this.unzipLocalMetadata(localPath, destination);
            } else {
                Path destination;
                URL targetUrl = this.metadataRepositoryConfiguration.getUrl();
                if (targetUrl == null) {
                    String version = this.metadataRepositoryConfiguration.getVersion();
                    if (version == null && (targetUrl = this.resolveDefaultMetadataRepositoryUrl()) == null) {
                        this.logger.warn("Unable to find the GraalVM reachability metadata repository in Maven repository. Falling back to the default repository.");
                        version = "0.2.4";
                    }
                    if (version != null) {
                        String metadataUrl = String.format("https://github.com/oracle/graalvm-reachability-metadata/releases/download/%1$s/graalvm-reachability-metadata-%1$s.zip", version);
                        try {
                            targetUrl = new URI(metadataUrl).toURL();
                            this.metadataRepositoryConfiguration.setUrl(targetUrl);
                        }
                        catch (MalformedURLException | URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                try {
                    destination = destinationRoot.resolve(FileUtils.hashFor((URI)targetUrl.toURI()));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                if (Files.exists(destination, new LinkOption[0])) {
                    repoPath = destination;
                } else {
                    Optional<Path> download = this.downloadMetadata(targetUrl, destination);
                    if (download.isPresent()) {
                        this.logger.info("Downloaded GraalVM reachability metadata repository from " + targetUrl);
                        repoPath = this.unzipLocalMetadata(download.get(), destination);
                    }
                }
            }
            if (repoPath == null) {
                this.logger.warn("GraalVM reachability metadata repository is enabled, but no repository has been configured");
            } else {
                this.metadataRepository = new FileSystemRepository(repoPath, new FileSystemRepository.Logger(){

                    public void log(String groupId, String artifactId, String version, Supplier<String> message) {
                        AbstractNativeMojo.this.logger.info(String.format("[graalvm reachability metadata repository for %s:%s:%s]: %s", groupId, artifactId, version, message.get()));
                    }
                });
            }
        }
    }

    private URL resolveDefaultMetadataRepositoryUrl() {
        RepositorySystemSession repositorySession = this.mavenSession.getRepositorySession();
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRepositories(this.project.getRemoteProjectRepositories());
        Dependency repository = new Dependency((Artifact)new DefaultArtifact(GROUP_ID, GRAALVM_REACHABILITY_METADATA_ARTIFACT_ID, "repository", REPOSITORY_FORMAT, "0.9.17"), "runtime");
        collectRequest.addDependency(repository);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
        DependencyResult dependencyResult = null;
        try {
            dependencyResult = this.repositorySystem.resolveDependencies(repositorySession, dependencyRequest);
        }
        catch (DependencyResolutionException e) {
            return null;
        }
        return dependencyResult.getArtifactResults().stream().filter(result -> result.getArtifact().getGroupId().equals(GROUP_ID) && result.getArtifact().getArtifactId().equals(GRAALVM_REACHABILITY_METADATA_ARTIFACT_ID)).findFirst().map(r -> {
            try {
                return r.getArtifact().getFile().toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).orElse(null);
    }

    public boolean isArtifactExcludedFromMetadataRepository(org.apache.maven.artifact.Artifact dependency) {
        if (this.metadataRepositoryConfiguration == null) {
            return false;
        }
        return this.metadataRepositoryConfiguration.isArtifactExcluded(dependency);
    }

    protected void maybeAddDependencyMetadata(org.apache.maven.artifact.Artifact dependency, Consumer<File> excludeAction) {
        if (this.isMetadataRepositoryEnabled() && this.metadataRepository != null && !this.isArtifactExcludedFromMetadataRepository(dependency)) {
            Set configurations = this.metadataRepository.findConfigurationsFor(q -> {
                q.useLatestConfigWhenVersionIsUntested();
                q.forArtifact(artifact -> {
                    artifact.gav(String.join((CharSequence)":", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()));
                    this.getMetadataVersion(dependency).ifPresent(arg_0 -> ((Query.ArtifactQuery)artifact).forceConfigVersion(arg_0));
                });
            });
            this.metadataRepositoryConfigurations.addAll(configurations);
            if (excludeAction != null && configurations.stream().anyMatch(DirectoryConfiguration::isOverride)) {
                excludeAction.accept(dependency.getFile());
            }
        }
    }

    protected Optional<String> getMetadataVersion(org.apache.maven.artifact.Artifact dependency) {
        if (this.metadataRepositoryConfiguration == null) {
            return Optional.empty();
        }
        return this.metadataRepositoryConfiguration.getMetadataVersion(dependency);
    }

    protected Optional<Path> downloadMetadata(URL url, Path destination) {
        return FileUtils.download((URL)url, (Path)destination, arg_0 -> ((Logger)this.logger).error(arg_0));
    }

    protected Path unzipLocalMetadata(Path localPath, Path destination) {
        if (Files.exists(localPath, new LinkOption[0])) {
            if (FileUtils.isZip((Path)localPath)) {
                if (!Files.exists(destination, new LinkOption[0]) && !destination.toFile().mkdirs()) {
                    throw new RuntimeException("Failed creating destination directory");
                }
                FileUtils.extract((Path)localPath, (Path)destination, arg_0 -> ((Logger)this.logger).error(arg_0));
                return destination;
            }
            if (Files.isDirectory(localPath, new LinkOption[0])) {
                return localPath;
            }
            this.logger.warn("Unable to extract metadata repository from " + localPath + ". It needs to be either a ZIP file or an exploded directory");
        } else {
            this.logger.error("GraalVM reachability metadata repository path does not exist: " + localPath);
        }
        return null;
    }
}

