/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.graalvm.buildtools.Utils;
import org.graalvm.buildtools.maven.AbstractNativeMojo;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class NativeTestMojo
extends AbstractNativeMojo {
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="classpath")
    private List<String> classpath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            this.logger.info("Tests are skipped.");
            return;
        }
        if (!this.hasTests()) {
            return;
        }
        String classpath = this.getClassPath();
        Path targetFolder = new File(this.project.getBuild().getDirectory()).toPath();
        targetFolder.toFile().mkdirs();
        this.logger.info("====================");
        this.logger.info("Initializing project: " + this.project.getName());
        this.logger.info("====================");
        if (!this.hasTestIds()) {
            this.logger.error("Test configuration file wasn't found.");
            this.logger.error("Add a following dependency to use the test listener mode:\n<dependency>\n    <groupId>org.graalvm.buildtools</groupId>\n    <artifactId>junit-platform-native</artifactId>\n    <version>0.9.5</version>\n    <scope>test</scope>\n</dependency>");
            throw new IllegalStateException("Test configuration file wasn't found.");
        }
        this.logger.debug("Classpath: " + classpath);
        this.buildImage(classpath, targetFolder);
        this.runTests(targetFolder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasTests() {
        Path testOutputPath = Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]);
        if (!Files.exists(testOutputPath, new LinkOption[0])) return false;
        if (!Files.isDirectory(testOutputPath, new LinkOption[0])) return false;
        try (DirectoryStream<Path> directory = Files.newDirectoryStream(testOutputPath);){
            boolean bl = directory.iterator().hasNext();
            return bl;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void buildImage(String classpath, Path targetFolder) throws MojoExecutionException {
        Path nativeImageExecutable = Utils.getNativeImage();
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(nativeImageExecutable.toString(), "-cp", classpath, "--features=org.graalvm.junit.platform.JUnitPlatformFeature", "-H:Path=" + targetFolder.toAbsolutePath(), "-H:Name=" + Utils.NATIVE_TESTS_EXE));
        this.maybeAddGeneratedResourcesConfig(command);
        if (this.buildArgs != null) {
            command.addAll(this.buildArgs);
        }
        command.add("org.graalvm.junit.platform.NativeImageJUnitLauncher");
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.directory(new File(this.project.getBuild().getDirectory()));
            processBuilder.inheritIO();
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            this.getLog().info((CharSequence)("Executing: " + commandString));
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Building image with " + nativeImageExecutable + " failed", e);
        }
    }

    private void runTests(Path targetFolder) throws MojoExecutionException {
        Path xmlLocation = targetFolder.resolve("native-test-reports");
        xmlLocation.toFile().mkdirs();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(targetFolder.resolve(Utils.NATIVE_TESTS_EXE).toAbsolutePath().toString(), "--xml-output-dir", xmlLocation.toString());
            processBuilder.inheritIO();
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            this.getLog().info((CharSequence)("Executing: " + commandString));
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("native-image test run failed");
        }
    }

    private String getClassPath() throws MojoFailureException {
        if (this.classpath != null && !this.classpath.isEmpty()) {
            return String.join((CharSequence)File.pathSeparator, this.classpath);
        }
        try {
            List pluginDependencies = this.pluginArtifacts.stream().filter(it -> it.getGroupId().startsWith("org.graalvm.buildtools") || it.getGroupId().startsWith("org.junit")).collect(Collectors.toList());
            ArrayList projectClassPath = new ArrayList(this.project.getTestClasspathElements());
            Stream<String> allResources = Stream.concat(this.project.getBuild().getResources().stream().map(FileSet::getDirectory), this.project.getBuild().getTestResources().stream().map(FileSet::getDirectory));
            return Stream.concat(Stream.concat(projectClassPath.stream(), allResources), pluginDependencies.stream().map(it -> it.getFile().toString())).collect(Collectors.joining(File.pathSeparator));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean hasTestIds() {
        try {
            Path buildDir = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
            return this.readAllFiles(buildDir, "junit-platform-unique-ids").anyMatch(contents -> !contents.isEmpty());
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Stream<String> readAllFiles(Path dir, String prefix) throws IOException {
        return NativeTestMojo.findFiles(dir, prefix).map(outputFile -> {
            try {
                return Files.readAllLines(outputFile);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }).flatMap(Collection::stream);
    }

    private static Stream<Path> findFiles(Path dir, String prefix) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.find(dir, Integer.MAX_VALUE, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().startsWith(prefix), new FileVisitOption[0]);
    }
}

