/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class FileUtils {
    public static final int CONNECT_TIMEOUT = 5000;
    public static final int READ_TIMEOUT = 5000;

    public static String normalizePathSeparators(String path) {
        return path.replace('\\', '/');
    }

    public static Optional<Path> download(URL url, Path destination, Consumer<String> errorLogger) {
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            if (connection.getResponseCode() == 200) {
                String fileName = "";
                String disposition = connection.getHeaderField("Content-Disposition");
                if (disposition != null) {
                    int index = disposition.indexOf("filename=");
                    if (index > 0) {
                        fileName = disposition.substring(index + 9);
                    }
                } else {
                    fileName = url.getFile().substring(url.getFile().lastIndexOf("/") + 1);
                }
                if (!Files.exists(destination, new LinkOption[0])) {
                    Files.createDirectories(destination, new FileAttribute[0]);
                }
                Path result = destination.resolve(fileName);
                Files.copy(connection.getInputStream(), result, new CopyOption[0]);
                connection.disconnect();
                return Optional.of(result);
            }
            errorLogger.accept("Failed to download from " + url + ": " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        catch (IOException e) {
            errorLogger.accept("Failed to download from " + url + ": " + e.getMessage());
        }
        return Optional.empty();
    }

    public static void extract(Path archive, Path destination, Consumer<String> errorLogger) {
        if (FileUtils.isZip(archive)) {
            try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(archive.toFile().toPath(), new OpenOption[0]));){
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    Optional<Path> sanitizedPath = FileUtils.sanitizePath(entry, destination);
                    if (sanitizedPath.isPresent()) {
                        Path zipEntryPath = sanitizedPath.get();
                        if (entry.isDirectory()) {
                            Files.createDirectories(zipEntryPath, new FileAttribute[0]);
                        } else {
                            if (zipEntryPath.getParent() != null && !Files.exists(zipEntryPath.getParent(), new LinkOption[0])) {
                                Files.createDirectories(zipEntryPath.getParent(), new FileAttribute[0]);
                            }
                            Files.copy(zis, zipEntryPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                    } else {
                        errorLogger.accept("Wrong entry " + entry.getName() + " in " + archive);
                    }
                    zis.closeEntry();
                    entry = zis.getNextEntry();
                }
            }
            catch (IOException e) {
                errorLogger.accept("Failed to extract " + archive + ": " + e.getMessage());
            }
        } else {
            errorLogger.accept("Unsupported archive format: " + archive + ". Only ZIP files are supported");
        }
    }

    public static boolean isZip(Path archive) {
        return archive.toString().toLowerCase().endsWith(".zip");
    }

    private static Optional<Path> sanitizePath(ZipEntry entry, Path destination) {
        Path normalized = destination.resolve(entry.getName()).normalize();
        if (normalized.startsWith(destination)) {
            return Optional.of(normalized);
        }
        return Optional.empty();
    }

    public static String hashFor(URI uri) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] messageDigest = md.digest(md.digest(uri.toString().getBytes(StandardCharsets.UTF_8)));
            BigInteger no = new BigInteger(1, messageDigest);
            StringBuilder digest = new StringBuilder(no.toString(16));
            while (digest.length() < 32) {
                digest.insert(0, "0");
            }
            return digest.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

