/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.graalvm.buildtools.utils.SharedConstants;

public class NativeImageUtils {
    public static void maybeCreateConfigureUtilSymlink(File configureUtilFile, Path nativeImageExecutablePath) {
        if (!configureUtilFile.exists()) {
            Path target = configureUtilFile.toPath();
            Path source = nativeImageExecutablePath.getParent().getParent().resolve("lib/svm/bin/" + NativeImageUtils.nativeImageConfigureFileName());
            if (Files.exists(source, new LinkOption[0])) {
                try {
                    Files.createLink(target, source);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static String nativeImageConfigureFileName() {
        return "native-image-configure" + SharedConstants.GRAALVM_EXE_EXTENSION;
    }

    public static List<String> convertToArgsFile(List<String> cliArgs, Path outputDir) {
        return NativeImageUtils.convertToArgsFile(cliArgs, outputDir, Paths.get("", new String[0]));
    }

    public static List<String> convertToArgsFile(List<String> cliArgs, Path outputDir, Path projectDir) {
        try {
            boolean ignored = outputDir.toFile().mkdirs();
            File tmpFile = Files.createTempFile(outputDir, "native-image-", ".args", new FileAttribute[0]).toFile();
            cliArgs = cliArgs.stream().map(NativeImageUtils::escapeArg).collect(Collectors.toList());
            Files.write(tmpFile.toPath(), cliArgs, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
            Path resultingPath = tmpFile.toPath().toAbsolutePath();
            if (projectDir != null) {
                resultingPath = projectDir.toAbsolutePath().relativize(resultingPath);
            }
            return Collections.singletonList("@" + resultingPath);
        }
        catch (IOException e) {
            return Collections.unmodifiableList(cliArgs);
        }
    }

    public static String escapeArg(String arg) {
        if ((arg = arg.replace("\\", "\\\\")).contains(" ")) {
            arg = "\"" + arg + "\"";
        }
        return arg;
    }
}

