/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.model.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.graalvm.buildtools.model.resources.ClassPathEntryAnalyzer;
import org.graalvm.buildtools.utils.FileUtils;

class JarAnalyzer
extends ClassPathEntryAnalyzer {
    private final File jarFile;

    JarAnalyzer(File jarFile, Function<String, Boolean> resourceFilter) {
        super(resourceFilter);
        this.jarFile = jarFile;
    }

    @Override
    protected List<String> initialize() throws IOException {
        ArrayList<String> resources = new ArrayList<String>();
        boolean hasNativeImageResourceFile = false;
        try (JarInputStream zin = new JarInputStream(new FileInputStream(this.jarFile));){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                boolean bl = hasNativeImageResourceFile = FileUtils.normalizePathSeparators(entry.getName()).startsWith("META-INF/native-image/") && entry.getName().endsWith("resource-config.json");
                if (hasNativeImageResourceFile) {
                    break;
                }
                if (entry.isDirectory()) continue;
                this.maybeAddResource(entry.getName(), resources);
            }
        }
        return hasNativeImageResourceFile ? Collections.emptyList() : resources;
    }
}

