/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.jni;

import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.substitutions.Collect;

/**
 * Generated by: {@link JniEnv#SetLongArrayRegion(StaticObject, int, int, TruffleObject, EspressoLanguage)}
 */
public final class JniEnv_SetLongArrayRegion__LIIL extends CallableFromNative {

    @Collect(value = com.oracle.truffle.espresso.jni.JniImpl.class) public static final class Factory extends CallableFromNative.Factory {

        public Factory() {
            super(
                "SetLongArrayRegion",
                NativeSignature.create(NativeType.VOID, NativeType.POINTER, NativeType.OBJECT, NativeType.INT, NativeType.INT, NativeType.POINTER),
                4,
                true
            );
        }

        @Override
        public final CallableFromNative create() {
            return new JniEnv_SetLongArrayRegion__LIIL();
        }

    }

    @SuppressWarnings(value = "unused") private JniEnv_SetLongArrayRegion__LIIL() {
    }

    @Override
    public final CallableFromNative split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object env, Object[] args) {
        com.oracle.truffle.api.TruffleSafepoint.poll(this);
        JniEnv jnienv = (JniEnv) env;
        StaticObject arg0 = jnienv.getHandles().get(Math.toIntExact((long) args[1]));
        int arg1 = (int) args[2];
        int arg2 = (int) args[3];
        TruffleObject arg3 = (TruffleObject) args[4];
        jnienv.SetLongArrayRegion(arg0, arg1, arg2, arg3, getLanguage());
        return StaticObject.NULL;
    }

    @Override
    public final String generatedBy() {
        return "JniImpl";
    }

}

