// CheckStyle: start generated
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.InstrumentableNode.WrapperNode;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.espresso.impl.Method.MethodVersion;

@GeneratedBy(AbstractInstrumentableBytecodeNode.class)
final class AbstractInstrumentableBytecodeNodeWrapper extends AbstractInstrumentableBytecodeNode implements WrapperNode {

    @Child private AbstractInstrumentableBytecodeNode delegateNode;
    @Child private ProbeNode probeNode;

    AbstractInstrumentableBytecodeNodeWrapper(AbstractInstrumentableBytecodeNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    @Override
    public AbstractInstrumentableBytecodeNode getDelegateNode() {
        return delegateNode;
    }

    @Override
    public ProbeNode getProbeNode() {
        return probeNode;
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    Object execute(VirtualFrame frame) {
        Object returnValue;
        for (;;) {
            boolean wasOnReturnExecuted = false;
            try {
                probeNode.onEnter(frame);
                returnValue = delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                probeNode.onReturnValue(frame, returnValue);
                break;
            } catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    continue;
                } else if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
        }
        return returnValue;
    }

    @Override
    public int getBci(Frame frame) {
        return this.delegateNode.getBci(frame);
    }

    @Override
    void initializeFrame(VirtualFrame frame) {
        this.delegateNode.initializeFrame(frame);
    }

    @Override
    MethodVersion getMethodVersion() {
        return this.delegateNode.getMethodVersion();
    }

    @Override
    protected boolean isTrivial() {
        return this.delegateNode.isTrivial();
    }

}
