// CheckStyle: start generated
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.InstrumentableNode.WrapperNode;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.impl.Method.MethodVersion;

@GeneratedBy(EspressoInstrumentableRootNode.class)
final class EspressoInstrumentableRootNodeWrapper extends EspressoInstrumentableRootNode implements WrapperNode {

    @Child private EspressoInstrumentableRootNode delegateNode;
    @Child private ProbeNode probeNode;

    EspressoInstrumentableRootNodeWrapper(EspressoInstrumentableRootNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    @Override
    public EspressoInstrumentableRootNode getDelegateNode() {
        return delegateNode;
    }

    @Override
    public ProbeNode getProbeNode() {
        return probeNode;
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    Object execute(VirtualFrame frame) {
        Object returnValue;
        for (;;) {
            boolean wasOnReturnExecuted = false;
            try {
                probeNode.onEnter(frame);
                returnValue = delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                probeNode.onReturnValue(frame, returnValue);
                break;
            } catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    continue;
                } else if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
        }
        return returnValue;
    }

    @Override
    public int getBci(Frame frame) {
        return this.delegateNode.getBci(frame);
    }

    @Override
    void beforeInstumentation(VirtualFrame frame) {
        this.delegateNode.beforeInstumentation(frame);
    }

    @Override
    MethodVersion getMethodVersion() {
        return this.delegateNode.getMethodVersion();
    }

    @Override
    public SourceSection getSourceSection() {
        return this.delegateNode.getSourceSection();
    }

    @Override
    boolean canSplit() {
        return this.delegateNode.canSplit();
    }

    @Override
    EspressoInstrumentableRootNode split() {
        return this.delegateNode.split();
    }

    @Override
    boolean isTrivial() {
        return this.delegateNode.isTrivial();
    }

}
