// CheckStyle: start generated
package com.oracle.truffle.espresso.nodes.quick;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;

@GeneratedBy(BaseQuickNode.class)
public final class BaseQuickNodeGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(BaseQuickNode.class, new NodeLibraryExports());
    }

    private BaseQuickNodeGen() {
    }

    @GeneratedBy(BaseQuickNode.class)
    public static class NodeLibraryExports extends LibraryExport<NodeLibrary> {

        private NodeLibraryExports() {
            super(NodeLibrary.class, BaseQuickNode.class, false, false, 0);
        }

        @Override
        protected NodeLibrary createUncached(Object receiver) {
            assert receiver instanceof BaseQuickNode;
            NodeLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected NodeLibrary createCached(Object receiver) {
            assert receiver instanceof BaseQuickNode;
            return new Cached(receiver);
        }

        @GeneratedBy(BaseQuickNode.class)
        public static class Cached extends NodeLibrary {

            private final Class<? extends BaseQuickNode> receiverClass_;

            protected Cached(Object receiver) {
                BaseQuickNode castReceiver = ((BaseQuickNode) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public boolean hasScope(Object receiver, Frame frame) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasScope(frame);
            }

            @Override
            public Object getScope(Object receiver, Frame frame, boolean nodeEnter) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).getScope(frame, nodeEnter);
            }

        }
        @GeneratedBy(BaseQuickNode.class)
        public static class Uncached extends NodeLibrary {

            private final Class<? extends BaseQuickNode> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((BaseQuickNode) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public final boolean isAdoptable() {
                return false;
            }

            @Override
            public final NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean hasScope(Object receiver, Frame frame) {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((BaseQuickNode) receiver) .hasScope(frame);
            }

            @Override
            public Object getScope(Object receiver, Frame frame, boolean nodeEnter) throws UnsupportedMessageException {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((BaseQuickNode) receiver) .getScope(frame, nodeEnter);
            }

        }
    }
}
