/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

/**
 * Generated by: {@link com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop}
 */
@com.oracle.truffle.espresso.substitutions.Collect(getter = "getInstance", value = com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes.class)
public final class EspressoInteropInteropNodes extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes {

    private static final Factory factory = new Factory(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.dispatchToId(EspressoInterop.class));

    private static final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes INSTANCE = new EspressoInteropInteropNodes();

    private EspressoInteropInteropNodes() {
        super(EspressoInterop.class, BaseInteropInteropNodes.getInstance());
    }

    public static com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes getInstance() {
        return INSTANCE;
    }

    static final class Factory implements com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory {

        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return sourceDispatch;
        }

        @Override
        public final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage create(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message message){
            switch (message) {
                case IsBoolean: return EspressoInteropInteropNodesFactory.IsBooleanNodeGen.create();
                case AsBoolean: return EspressoInteropInteropNodesFactory.AsBooleanNodeGen.create();
                case IsNumber: return EspressoInteropInteropNodesFactory.IsNumberNodeGen.create();
                case FitsInByte: return EspressoInteropInteropNodesFactory.FitsInByteNodeGen.create();
                case FitsInShort: return EspressoInteropInteropNodesFactory.FitsInShortNodeGen.create();
                case FitsInInt: return EspressoInteropInteropNodesFactory.FitsInIntNodeGen.create();
                case FitsInLong: return EspressoInteropInteropNodesFactory.FitsInLongNodeGen.create();
                case FitsInFloat: return EspressoInteropInteropNodesFactory.FitsInFloatNodeGen.create();
                case FitsInDouble: return EspressoInteropInteropNodesFactory.FitsInDoubleNodeGen.create();
                case AsByte: return EspressoInteropInteropNodesFactory.AsByteNodeGen.create();
                case AsShort: return EspressoInteropInteropNodesFactory.AsShortNodeGen.create();
                case AsInt: return EspressoInteropInteropNodesFactory.AsIntNodeGen.create();
                case AsLong: return EspressoInteropInteropNodesFactory.AsLongNodeGen.create();
                case AsFloat: return EspressoInteropInteropNodesFactory.AsFloatNodeGen.create();
                case AsDouble: return EspressoInteropInteropNodesFactory.AsDoubleNodeGen.create();
                case GetArraySize: return EspressoInteropInteropNodesFactory.GetArraySizeNodeGen.create();
                case HasArrayElements: return EspressoInteropInteropNodesFactory.HasArrayElementsNodeGen.create();
                case ReadArrayElement: return EspressoInteropInteropNodesFactory.ReadArrayElementNodeGen.create();
                case WriteArrayElement: return EspressoInteropInteropNodesFactory.WriteArrayElementNodeGen.create();
                case IsArrayElementInsertable: return EspressoInteropInteropNodesFactory.IsArrayElementInsertableNodeGen.create();
                case ReadMember: return EspressoInteropInteropNodesFactory.ReadMemberNodeGen.create();
                case HasMembers: return EspressoInteropInteropNodesFactory.HasMembersNodeGen.create();
                case IsMemberReadable: return EspressoInteropInteropNodesFactory.IsMemberReadableNodeGen.create();
                case IsMemberModifiable: return EspressoInteropInteropNodesFactory.IsMemberModifiableNodeGen.create();
                case WriteMember: return EspressoInteropInteropNodesFactory.WriteMemberNodeGen.create();
                case IsMemberInsertable: return EspressoInteropInteropNodesFactory.IsMemberInsertableNodeGen.create();
                case GetMembers: return EspressoInteropInteropNodesFactory.GetMembersNodeGen.create();
                case IsMemberInvocable: return EspressoInteropInteropNodesFactory.IsMemberInvocableNodeGen.create();
                case InvokeMember: return EspressoInteropInteropNodesFactory.InvokeMemberNodeGen.create();
                case IsDate: return EspressoInteropInteropNodesFactory.IsDateNodeGen.create();
                case AsDate: return EspressoInteropInteropNodesFactory.AsDateNodeGen.create();
                case IsTime: return EspressoInteropInteropNodesFactory.IsTimeNodeGen.create();
                case AsTime: return EspressoInteropInteropNodesFactory.AsTimeNodeGen.create();
                case IsTimeZone: return EspressoInteropInteropNodesFactory.IsTimeZoneNodeGen.create();
                case AsTimeZone: return EspressoInteropInteropNodesFactory.AsTimeZoneNodeGen.create();
                case AsInstant: return EspressoInteropInteropNodesFactory.AsInstantNodeGen.create();
                case IsDuration: return EspressoInteropInteropNodesFactory.IsDurationNodeGen.create();
                case AsDuration: return EspressoInteropInteropNodesFactory.AsDurationNodeGen.create();
                default: return null;
            }
        }

    }

    abstract static class IsBooleanNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsBoolean {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isBoolean(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.isBoolean(receiver);
        }

    }

    abstract static class AsBooleanNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsBoolean {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean asBoolean(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asBoolean(receiver);
        }

    }

    abstract static class IsNumberNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsNumber {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isNumber(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.isNumber(receiver);
        }

    }

    abstract static class FitsInByteNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.FitsInByte {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean fitsInByte(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.fitsInByte(receiver);
        }

    }

    abstract static class FitsInShortNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.FitsInShort {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean fitsInShort(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.fitsInShort(receiver);
        }

    }

    abstract static class FitsInIntNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.FitsInInt {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean fitsInInt(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.fitsInInt(receiver);
        }

    }

    abstract static class FitsInLongNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.FitsInLong {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean fitsInLong(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.fitsInLong(receiver);
        }

    }

    abstract static class FitsInFloatNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.FitsInFloat {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean fitsInFloat(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.fitsInFloat(receiver);
        }

    }

    abstract static class FitsInDoubleNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.FitsInDouble {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean fitsInDouble(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.fitsInDouble(receiver);
        }

    }

    abstract static class AsByteNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsByte {

        @com.oracle.truffle.api.dsl.Specialization
        static byte asByte(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asByte(receiver);
        }

    }

    abstract static class AsShortNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsShort {

        @com.oracle.truffle.api.dsl.Specialization
        static short asShort(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asShort(receiver);
        }

    }

    abstract static class AsIntNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsInt {

        @com.oracle.truffle.api.dsl.Specialization
        static int asInt(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asInt(receiver);
        }

    }

    abstract static class AsLongNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsLong {

        @com.oracle.truffle.api.dsl.Specialization
        static long asLong(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asLong(receiver);
        }

    }

    abstract static class AsFloatNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsFloat {

        @com.oracle.truffle.api.dsl.Specialization
        static float asFloat(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asFloat(receiver);
        }

    }

    abstract static class AsDoubleNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsDouble {

        @com.oracle.truffle.api.dsl.Specialization
        static double asDouble(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asDouble(receiver);
        }

    }

    abstract static class GetArraySizeNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetArraySize {

        @com.oracle.truffle.api.dsl.Specialization
        static long getArraySize(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, @com.oracle.truffle.api.library.CachedLibrary(limit = "1") com.oracle.truffle.api.interop.InteropLibrary receiverLib, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.getArraySize(receiver, receiverLib, error);
        }

    }

    abstract static class HasArrayElementsNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.HasArrayElements {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean hasArrayElements(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.hasArrayElements(receiver);
        }

    }

    abstract static class ReadArrayElementNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.ReadArrayElement {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object readArrayElement(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, long index, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.Nodes.ReadArrayElementImplNode readArrayElementNode) throws com.oracle.truffle.api.interop.UnsupportedMessageException, com.oracle.truffle.api.interop.InvalidArrayIndexException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.readArrayElement(receiver, index, readArrayElementNode);
        }

    }

    abstract static class WriteArrayElementNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.WriteArrayElement {

        @com.oracle.truffle.api.dsl.Specialization
        static void writeArrayElement(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, long index, java.lang.Object value, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.Nodes.WriteArrayElementImplNode writeArrayElementNode) throws com.oracle.truffle.api.interop.UnsupportedMessageException, com.oracle.truffle.api.interop.InvalidArrayIndexException, com.oracle.truffle.api.interop.UnsupportedTypeException{
            com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.writeArrayElement(receiver, index, value, writeArrayElementNode);
        }

    }

    abstract static class IsArrayElementInsertableNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsArrayElementInsertable {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isArrayElementInsertable(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, long index){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.isArrayElementInsertable(receiver, index);
        }

    }

    abstract static class ReadMemberNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.ReadMember {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object readMember(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.String member, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.LookupInstanceFieldNode lookupField, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.LookupVirtualMethodNode lookupMethod) throws com.oracle.truffle.api.interop.UnknownIdentifierException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.readMember(receiver, member, lookupField, lookupMethod);
        }

    }

    abstract static class HasMembersNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.HasMembers {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean hasMembers(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.hasMembers(receiver);
        }

    }

    abstract static class IsMemberReadableNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsMemberReadable {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isMemberReadable(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.String member, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.LookupInstanceFieldNode lookupField, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.LookupVirtualMethodNode lookupMethod){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.isMemberReadable(receiver, member, lookupField, lookupMethod);
        }

    }

    abstract static class IsMemberModifiableNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsMemberModifiable {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isMemberModifiable(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.String member, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.LookupInstanceFieldNode lookup){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.isMemberModifiable(receiver, member, lookup);
        }

    }

    abstract static class WriteMemberNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.WriteMember {

        @com.oracle.truffle.api.dsl.Specialization
        static void writeMember(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.String member, java.lang.Object value, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.LookupInstanceFieldNode lookup, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.ToEspressoNode.DynamicToEspresso toEspresso, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedTypeException, com.oracle.truffle.api.interop.UnknownIdentifierException, com.oracle.truffle.api.interop.UnsupportedMessageException{
            com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.writeMember(receiver, member, value, lookup, toEspresso, error);
        }

    }

    abstract static class IsMemberInsertableNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsMemberInsertable {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isMemberInsertable(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.String member){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.isMemberInsertable(receiver, member);
        }

    }

    abstract static class GetMembersNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetMembers {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object getMembers(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, boolean includeInternal){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.getMembers(receiver, includeInternal);
        }

    }

    abstract static class IsMemberInvocableNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsMemberInvocable {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isMemberInvocable(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.String member, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.LookupVirtualMethodNode lookupMethod){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.isMemberInvocable(receiver, member, lookupMethod);
        }

    }

    abstract static class InvokeMemberNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.InvokeMember {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object invokeMember(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.String member, java.lang.Object[] arguments, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.LookupVirtualMethodNode lookupMethod, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.OverLoadedMethodSelectorNode selectorNode, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode invoke, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.ToEspressoNode.DynamicToEspresso toEspressoNode) throws com.oracle.truffle.api.interop.ArityException, com.oracle.truffle.api.interop.UnknownIdentifierException, com.oracle.truffle.api.interop.UnsupportedTypeException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.invokeMember(receiver, member, arguments, lookupMethod, selectorNode, invoke, toEspressoNode);
        }

    }

    abstract static class IsDateNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsDate {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isDate(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.isDate(receiver);
        }

    }

    abstract static class AsDateNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsDate {

        @com.oracle.truffle.api.dsl.Specialization
        static java.time.LocalDate asDate(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asDate(receiver, error);
        }

    }

    abstract static class IsTimeNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsTime {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isTime(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.isTime(receiver);
        }

    }

    abstract static class AsTimeNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsTime {

        @com.oracle.truffle.api.dsl.Specialization
        static java.time.LocalTime asTime(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asTime(receiver, error);
        }

    }

    abstract static class IsTimeZoneNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsTimeZone {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isTimeZone(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.isTimeZone(receiver);
        }

    }

    abstract static class AsTimeZoneNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsTimeZone {

        @com.oracle.truffle.api.dsl.Specialization
        static java.time.ZoneId asTimeZone(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asTimeZone(receiver, error);
        }

    }

    abstract static class AsInstantNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsInstant {

        @com.oracle.truffle.api.dsl.Specialization
        static java.time.Instant asInstant(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, @com.oracle.truffle.api.library.CachedLibrary(limit = "1") com.oracle.truffle.api.interop.InteropLibrary receiverLibrary, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asInstant(receiver, receiverLibrary, error);
        }

    }

    abstract static class IsDurationNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsDuration {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isDuration(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.isDuration(receiver);
        }

    }

    abstract static class AsDurationNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsDuration {

        @com.oracle.truffle.api.dsl.Specialization
        static java.time.Duration asDuration(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop.asDuration(receiver, error);
        }

    }

    @Override
    protected void registerMessages(Class<?> cls) {
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsBoolean, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsBoolean, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsNumber, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.FitsInByte, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.FitsInShort, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.FitsInInt, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.FitsInLong, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.FitsInFloat, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.FitsInDouble, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsByte, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsShort, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsInt, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsLong, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsFloat, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsDouble, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetArraySize, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.HasArrayElements, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.ReadArrayElement, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.WriteArrayElement, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsArrayElementInsertable, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.ReadMember, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.HasMembers, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsMemberReadable, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsMemberModifiable, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.WriteMember, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsMemberInsertable, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetMembers, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsMemberInvocable, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.InvokeMember, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsDate, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsDate, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsTime, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsTime, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsTimeZone, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsTimeZone, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsInstant, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsDuration, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsDuration, factory,true);
    }

}

