/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

/**
 * Generated by: {@link com.oracle.truffle.espresso.runtime.dispatch.staticobject.InterruptedExceptionInterop}
 */
@com.oracle.truffle.espresso.substitutions.Collect(getter = "getInstance", value = com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes.class)
public final class InterruptedExceptionInteropInteropNodes extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes {

    private static final Factory factory = new Factory(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.dispatchToId(InterruptedExceptionInterop.class));

    private static final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes INSTANCE = new InterruptedExceptionInteropInteropNodes();

    private InterruptedExceptionInteropInteropNodes() {
        super(InterruptedExceptionInterop.class, ThrowableInteropInteropNodes.getInstance());
    }

    public static com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes getInstance() {
        return INSTANCE;
    }

    static final class Factory implements com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory {

        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return sourceDispatch;
        }

        @Override
        public final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage create(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message message){
            switch (message) {
                case GetExceptionType: return InterruptedExceptionInteropInteropNodesFactory.GetExceptionTypeNodeGen.create();
                default: return null;
            }
        }

    }

    abstract static class GetExceptionTypeNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetExceptionType {

        @com.oracle.truffle.api.dsl.Specialization
        static com.oracle.truffle.api.interop.ExceptionType getExceptionType(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.InterruptedExceptionInterop.getExceptionType(receiver);
        }

    }

    @Override
    protected void registerMessages(Class<?> cls) {
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetExceptionType, factory,true);
    }

}

