/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

/**
 * Generated by: {@link com.oracle.truffle.espresso.runtime.dispatch.staticobject.IterableInterop}
 */
@com.oracle.truffle.espresso.substitutions.Collect(getter = "getInstance", value = com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes.class)
public final class IterableInteropInteropNodes extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes {

    private static final Factory factory = new Factory(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.dispatchToId(IterableInterop.class));

    private static final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes INSTANCE = new IterableInteropInteropNodes();

    private IterableInteropInteropNodes() {
        super(IterableInterop.class, EspressoInteropInteropNodes.getInstance());
    }

    public static com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes getInstance() {
        return INSTANCE;
    }

    static final class Factory implements com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory {

        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return sourceDispatch;
        }

        @Override
        public final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage create(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message message){
            switch (message) {
                case HasIterator: return IterableInteropInteropNodesFactory.HasIteratorNodeGen.create();
                case GetIterator: return IterableInteropInteropNodesFactory.GetIteratorNodeGen.create();
                default: return null;
            }
        }

    }

    abstract static class HasIteratorNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.HasIterator {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean hasIterator(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.IterableInterop.hasIterator(receiver);
        }

    }

    abstract static class GetIteratorNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetIterator {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object getIterator(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, @com.oracle.truffle.api.dsl.Bind(value = "getMeta().java_lang_Iterable_iterator") com.oracle.truffle.espresso.impl.Method iteratorMethod, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.LookupAndInvokeKnownMethodNode lookupAndInvoke){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.IterableInterop.getIterator(receiver, iteratorMethod, lookupAndInvoke);
        }

    }

    @Override
    protected void registerMessages(Class<?> cls) {
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.HasIterator, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetIterator, factory,false);
    }

}

