/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

/**
 * Generated by: {@link com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapInterop}
 */
@com.oracle.truffle.espresso.substitutions.Collect(getter = "getInstance", value = com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes.class)
public final class MapInteropInteropNodes extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes {

    private static final Factory factory = new Factory(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.dispatchToId(MapInterop.class));

    private static final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes INSTANCE = new MapInteropInteropNodes();

    private MapInteropInteropNodes() {
        super(MapInterop.class, EspressoInteropInteropNodes.getInstance());
    }

    public static com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes getInstance() {
        return INSTANCE;
    }

    static final class Factory implements com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory {

        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return sourceDispatch;
        }

        @Override
        public final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage create(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message message){
            switch (message) {
                case HasHashEntries: return MapInteropInteropNodesFactory.HasHashEntriesNodeGen.create();
                case IsHashEntryInsertable: return MapInteropInteropNodesFactory.IsHashEntryInsertableNodeGen.create();
                case GetHashSize: return MapInteropInteropNodesFactory.GetHashSizeNodeGen.create();
                case ReadHashValue: return MapInteropInteropNodesFactory.ReadHashValueNodeGen.create();
                case WriteHashEntry: return MapInteropInteropNodesFactory.WriteHashEntryNodeGen.create();
                case RemoveHashEntry: return MapInteropInteropNodesFactory.RemoveHashEntryNodeGen.create();
                case GetHashEntriesIterator: return MapInteropInteropNodesFactory.GetHashEntriesIteratorNodeGen.create();
                default: return null;
            }
        }

    }

    abstract static class HasHashEntriesNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.HasHashEntries {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean hasHashEntries(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapInterop.hasHashEntries(receiver);
        }

    }

    abstract static class IsHashEntryInsertableNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsHashEntryInsertable {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isHashEntryInsertable(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.Object key, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode invoke){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapInterop.isHashEntryInsertable(receiver, key, invoke);
        }

    }

    abstract static class GetHashSizeNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetHashSize {

        @com.oracle.truffle.api.dsl.Specialization
        static long getHashSize(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode invoke) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapInterop.getHashSize(receiver, invoke);
        }

    }

    abstract static class ReadHashValueNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.ReadHashValue {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object readHashValue(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.Object key, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode invoke, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode contains) throws com.oracle.truffle.api.interop.UnsupportedMessageException, com.oracle.truffle.api.interop.UnknownKeyException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapInterop.readHashValue(receiver, key, invoke, contains);
        }

    }

    abstract static class WriteHashEntryNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.WriteHashEntry {

        @com.oracle.truffle.api.dsl.Specialization
        static void writeHashEntry(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.Object key, java.lang.Object value, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode invoke) throws com.oracle.truffle.api.interop.UnknownKeyException{
            com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapInterop.writeHashEntry(receiver, key, value, invoke);
        }

    }

    abstract static class RemoveHashEntryNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.RemoveHashEntry {

        @com.oracle.truffle.api.dsl.Specialization
        static void removeHashEntry(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.Object key, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode invoke, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode contains) throws com.oracle.truffle.api.interop.UnsupportedMessageException, com.oracle.truffle.api.interop.UnknownKeyException{
            com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapInterop.removeHashEntry(receiver, key, invoke, contains);
        }

    }

    abstract static class GetHashEntriesIteratorNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetHashEntriesIterator {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object getHashEntriesIterator(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, @com.oracle.truffle.api.library.CachedLibrary(limit = "1") com.oracle.truffle.api.interop.InteropLibrary setLibrary, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode invoke) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapInterop.getHashEntriesIterator(receiver, setLibrary, invoke);
        }

    }

    @Override
    protected void registerMessages(Class<?> cls) {
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.HasHashEntries, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsHashEntryInsertable, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetHashSize, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.ReadHashValue, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.WriteHashEntry, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.RemoveHashEntry, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetHashEntriesIterator, factory,false);
    }

}

