/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

/**
 * Generated by: {@link com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInterop}
 */
@com.oracle.truffle.espresso.substitutions.Collect(getter = "getInstance", value = com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes.class)
public final class ThrowableInteropInteropNodes extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes {

    private static final Factory factory = new Factory(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.dispatchToId(ThrowableInterop.class));

    private static final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes INSTANCE = new ThrowableInteropInteropNodes();

    private ThrowableInteropInteropNodes() {
        super(ThrowableInterop.class, EspressoInteropInteropNodes.getInstance());
    }

    public static com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes getInstance() {
        return INSTANCE;
    }

    static final class Factory implements com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory {

        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return sourceDispatch;
        }

        @Override
        public final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage create(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message message){
            switch (message) {
                case GetExceptionType: return ThrowableInteropInteropNodesFactory.GetExceptionTypeNodeGen.create();
                case IsException: return ThrowableInteropInteropNodesFactory.IsExceptionNodeGen.create();
                case ThrowException: return ThrowableInteropInteropNodesFactory.ThrowExceptionNodeGen.create();
                case HasExceptionCause: return ThrowableInteropInteropNodesFactory.HasExceptionCauseNodeGen.create();
                case GetExceptionCause: return ThrowableInteropInteropNodesFactory.GetExceptionCauseNodeGen.create();
                case HasExceptionMessage: return ThrowableInteropInteropNodesFactory.HasExceptionMessageNodeGen.create();
                case GetExceptionMessage: return ThrowableInteropInteropNodesFactory.GetExceptionMessageNodeGen.create();
                default: return null;
            }
        }

    }

    abstract static class GetExceptionTypeNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetExceptionType {

        @com.oracle.truffle.api.dsl.Specialization
        static com.oracle.truffle.api.interop.ExceptionType getExceptionType(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInterop.getExceptionType(receiver);
        }

    }

    abstract static class IsExceptionNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsException {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isException(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInterop.isException(object);
        }

    }

    abstract static class ThrowExceptionNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.ThrowException {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.RuntimeException throwException(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInterop.throwException(object);
        }

    }

    abstract static class HasExceptionCauseNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.HasExceptionCause {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean hasExceptionCause(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInterop.hasExceptionCause(object);
        }

    }

    abstract static class GetExceptionCauseNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetExceptionCause {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object getExceptionCause(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInterop.getExceptionCause(object);
        }

    }

    abstract static class HasExceptionMessageNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.HasExceptionMessage {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean hasExceptionMessage(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInterop.hasExceptionMessage(object);
        }

    }

    abstract static class GetExceptionMessageNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetExceptionMessage {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object getExceptionMessage(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInterop.getExceptionMessage(object);
        }

    }

    @Override
    protected void registerMessages(Class<?> cls) {
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetExceptionType, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsException, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.ThrowException, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.HasExceptionCause, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetExceptionCause, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.HasExceptionMessage, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetExceptionMessage, factory,true);
    }

}

