/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedFrameAccess;
import com.oracle.truffle.espresso.nodes.EspressoFrame;

/**
 * Generated by: {@link Target_java_lang_Math#round(double)}
 */
public final class Target_java_lang_Math_round__D extends JavaSubstitution {

    @Collect(value = com.oracle.truffle.espresso.substitutions.Substitution.class) public static final class Factory extends JavaSubstitution.Factory {

        public Factory() {
            super(
                "round",
                "Target_java_lang_Math",
                "J",
                new String[]{
                    "D",
                },
                false
            );
        }

        @Override
        public boolean inlineInBytecode() {
            return true;
        }

        @Override
        public final JavaSubstitution create() {
            return new Target_java_lang_Math_round__D();
        }

    }

    @SuppressWarnings(value = "unused") private Target_java_lang_Math_round__D() {
    }

    @Override
    public final JavaSubstitution split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object[] args) {
        double arg0 = (double) args[0];
        return Target_java_lang_Math.round(arg0);

    }

    @Override
    public final void invokeInlined(VirtualFrame frame, int top, InlinedFrameAccess frameAccess) {
        double arg0 = EspressoFrame.popDouble(frame, top - 1);
        frameAccess.pushResult(frame, Target_java_lang_Math.round(arg0));
    }

}

