/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.meta.Meta;

/**
 * Generated by: {@link Target_java_lang_Object#wait(StaticObject, long, Meta, SubstitutionProfiler)}
 */
public final class Target_java_lang_Object_wait__LJ extends JavaSubstitution {

    @Collect(value = com.oracle.truffle.espresso.substitutions.Substitution.class) public static final class Factory extends JavaSubstitution.Factory {

        public Factory() {
            super(
                "wait",
                "Target_java_lang_Object",
                "V",
                new String[]{
                    "Ljava/lang/Object;",
                    "J",
                },
                true
            );
        }

        @Override
        public final JavaSubstitution create() {
            return new Target_java_lang_Object_wait__LJ();
        }

    }

    @SuppressWarnings(value = "unused") private Target_java_lang_Object_wait__LJ() {
    }

    @Override
    public final JavaSubstitution split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object[] args) {
        StaticObject arg0 = (StaticObject) args[0];
        long arg1 = (long) args[1];
        EspressoContext context = getContext();
        Target_java_lang_Object.wait(arg0, arg1, context.getMeta(), this);

        return StaticObject.NULL;
    }

}

