/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.Meta;

/**
 * Generated by: {@link Target_java_lang_StackStreamFactory_AbstractStackWalker#callStackWalk(StaticObject, long, int, StaticObject, StaticObject, int, int, StaticObject, EspressoLanguage, Meta)}
 */
public final class Target_java_lang_StackStreamFactory_AbstractStackWalker_callStackWalk__LJILLIIL extends JavaSubstitution {

    @Collect(value = com.oracle.truffle.espresso.substitutions.Substitution.class) public static final class Factory extends JavaSubstitution.Factory {

        public Factory() {
            super(
                "callStackWalk",
                "Target_java_lang_StackStreamFactory_AbstractStackWalker",
                "Ljava/lang/Object;",
                new String[]{
                    "Ljava/lang/StackStreamFactory$AbstractStackWalker;",
                    "J",
                    "I",
                    "Ljdk/internal/vm/ContinuationScope;",
                    "Ljdk/internal/vm/Continuation;",
                    "I",
                    "I",
                    "[Ljava/lang/Object;",
                },
                true
            );
        }

        @Override
        public final String[] getMethodNames() {
            return Target_java_lang_StackStreamFactory_AbstractStackWalker.Provider.INSTANCE.getMethodNames("callStackWalk");
        }

        @Override
        public final String[] substitutionClassNames() {
            return Target_java_lang_StackStreamFactory_AbstractStackWalker.Provider.INSTANCE.substitutionClassNames();
        }

        @Override
        public final boolean isValidFor(com.oracle.truffle.espresso.runtime.JavaVersion version) {
            return com.oracle.truffle.espresso.substitutions.VersionFilter.Java19OrLater.INSTANCE.isValidFor(version);
        }

        @Override
        public final JavaSubstitution create() {
            return new Target_java_lang_StackStreamFactory_AbstractStackWalker_callStackWalk__LJILLIIL();
        }

    }

    @SuppressWarnings(value = "unused") private Target_java_lang_StackStreamFactory_AbstractStackWalker_callStackWalk__LJILLIIL() {
    }

    @Override
    public final JavaSubstitution split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object[] args) {
        StaticObject arg0 = (StaticObject) args[0];
        long arg1 = (long) args[1];
        int arg2 = (int) args[2];
        StaticObject arg3 = (StaticObject) args[3];
        StaticObject arg4 = (StaticObject) args[4];
        int arg5 = (int) args[5];
        int arg6 = (int) args[6];
        StaticObject arg7 = (StaticObject) args[7];
        EspressoContext context = getContext();
        return Target_java_lang_StackStreamFactory_AbstractStackWalker.callStackWalk(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, getLanguage(), context.getMeta());

    }

}

