/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Target_java_lang_reflect_ProxyGenerator.GenerateProxyClass;

/**
 * Generated by: {@link com.oracle.truffle.espresso.substitutions.Target_java_lang_reflect_ProxyGenerator.GenerateProxyClass}
 */
public final class Target_java_lang_reflect_ProxyGenerator_GenerateProxyClass__LLI extends JavaSubstitution {

    @Collect(value = com.oracle.truffle.espresso.substitutions.Substitution.class) public static final class Factory extends JavaSubstitution.Factory {

        public Factory() {
            super(
                "generateProxyClass",
                "Target_java_lang_reflect_ProxyGenerator",
                "[B",
                new String[]{
                    "Ljava/lang/String;",
                    "[Ljava/lang/Class;",
                    "I",
                },
                false
            );
        }

        @Override
        public final boolean isValidFor(com.oracle.truffle.espresso.runtime.JavaVersion version) {
            return com.oracle.truffle.espresso.substitutions.VersionFilter.Java9OrLater.INSTANCE.isValidFor(version);
        }

        @Override
        public final JavaSubstitution create() {
            return new Target_java_lang_reflect_ProxyGenerator_GenerateProxyClass__LLI();
        }

    }

    @Child private GenerateProxyClass node;

    @SuppressWarnings(value = "unused") private Target_java_lang_reflect_ProxyGenerator_GenerateProxyClass__LLI() {
        this.node = com.oracle.truffle.espresso.substitutions.Target_java_lang_reflect_ProxyGeneratorFactory.GenerateProxyClassNodeGen.create();
    }

    @Override
    public final JavaSubstitution split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object[] args) {
        StaticObject arg0 = (StaticObject) args[0];
        StaticObject arg1 = (StaticObject) args[1];
        int arg2 = (int) args[2];
        return this.node.execute(arg0, arg1, arg2);

    }

}

