/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Target_sun_misc_Unsafe.CompareAndExchangeShort;

/**
 * Generated by: {@link com.oracle.truffle.espresso.substitutions.Target_sun_misc_Unsafe.CompareAndExchangeShort}
 */
public final class Target_sun_misc_Unsafe_CompareAndExchangeShort__LLJLL extends JavaSubstitution {

    @Collect(value = com.oracle.truffle.espresso.substitutions.Substitution.class) public static final class Factory extends JavaSubstitution.Factory {

        public Factory() {
            super(
                "compareAndExchangeShort",
                "Target_sun_misc_Unsafe",
                "S",
                new String[]{
                    "Lsun/misc/Unsafe;",
                    "Ljava/lang/Object;",
                    "J",
                    "S",
                    "S",
                },
                true
            );
        }

        @Override
        public final String[] getMethodNames() {
            return Target_sun_misc_Unsafe.SharedUnsafe.INSTANCE.getMethodNames("compareAndExchangeShort");
        }

        @Override
        public final String[] substitutionClassNames() {
            return Target_sun_misc_Unsafe.SharedUnsafe.INSTANCE.substitutionClassNames();
        }

        @Override
        public final JavaSubstitution create() {
            return new Target_sun_misc_Unsafe_CompareAndExchangeShort__LLJLL();
        }

    }

    @Child private CompareAndExchangeShort node;

    @SuppressWarnings(value = "unused") private Target_sun_misc_Unsafe_CompareAndExchangeShort__LLJLL() {
        this.node = com.oracle.truffle.espresso.substitutions.Target_sun_misc_UnsafeFactory.CompareAndExchangeShortNodeGen.create();
    }

    @Override
    public final JavaSubstitution split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object[] args) {
        StaticObject arg0 = (StaticObject) args[0];
        StaticObject arg1 = (StaticObject) args[1];
        long arg2 = (long) args[2];
        short arg3 = (short) args[3];
        short arg4 = (short) args[4];
        return this.node.execute(arg0, arg1, arg2, arg3, arg4);

    }

}

