/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedFrameAccess;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Target_sun_misc_Unsafe.CompareAndSwapInt;

/**
 * Generated by: {@link com.oracle.truffle.espresso.substitutions.Target_sun_misc_Unsafe.CompareAndSwapInt}
 */
public final class Target_sun_misc_Unsafe_CompareAndSwapInt__LLJII extends JavaSubstitution {

    @Collect(value = com.oracle.truffle.espresso.substitutions.Substitution.class) public static final class Factory extends JavaSubstitution.Factory {

        public Factory() {
            super(
                "compareAndSwapInt",
                "Target_sun_misc_Unsafe",
                "Z",
                new String[]{
                    "Lsun/misc/Unsafe;",
                    "Ljava/lang/Object;",
                    "J",
                    "I",
                    "I",
                },
                true
            );
        }

        @Override
        public final String[] getMethodNames() {
            return Target_sun_misc_Unsafe.Unsafe8.INSTANCE.getMethodNames("compareAndSwapInt");
        }

        @Override
        public final String[] substitutionClassNames() {
            return Target_sun_misc_Unsafe.Unsafe8.INSTANCE.substitutionClassNames();
        }

        @Override
        public boolean inlineInBytecode() {
            return true;
        }

        @Override
        public final JavaSubstitution create() {
            return new Target_sun_misc_Unsafe_CompareAndSwapInt__LLJII();
        }

    }

    @Child private CompareAndSwapInt node;

    @SuppressWarnings(value = "unused") private Target_sun_misc_Unsafe_CompareAndSwapInt__LLJII() {
        this.node = com.oracle.truffle.espresso.substitutions.Target_sun_misc_UnsafeFactory.CompareAndSwapIntNodeGen.create();
    }

    @Override
    public final JavaSubstitution split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object[] args) {
        StaticObject arg0 = (StaticObject) args[0];
        StaticObject arg1 = (StaticObject) args[1];
        long arg2 = (long) args[2];
        int arg3 = (int) args[3];
        int arg4 = (int) args[4];
        return this.node.execute(arg0, arg1, arg2, arg3, arg4);

    }

    @Override
    public final void invokeInlined(VirtualFrame frame, int top, InlinedFrameAccess frameAccess) {
        int arg4 = EspressoFrame.popInt(frame, top - 1);
        int arg3 = EspressoFrame.popInt(frame, top - 2);
        long arg2 = EspressoFrame.popLong(frame, top - 3);
        StaticObject arg1 = EspressoFrame.popObject(frame, top - 5);
        StaticObject arg0 = EspressoFrame.popObject(frame, top - 6);
        frameAccess.pushResult(frame, (this.node.execute(arg0, arg1, arg2, arg3, arg4)) ? 1 : 0);
    }

}

