/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Target_sun_reflect_NativeConstructorAccessorImpl.NewInstance0;
import com.oracle.truffle.espresso.runtime.EspressoContext;

/**
 * Generated by: {@link com.oracle.truffle.espresso.substitutions.Target_sun_reflect_NativeConstructorAccessorImpl.NewInstance0}
 */
public final class Target_sun_reflect_NativeConstructorAccessorImpl_NewInstance0__LL extends JavaSubstitution {

    @Collect(value = com.oracle.truffle.espresso.substitutions.Substitution.class) public static final class Factory extends JavaSubstitution.Factory {

        public Factory() {
            super(
                "newInstance0",
                "Target_sun_reflect_NativeConstructorAccessorImpl",
                "Ljava/lang/Object;",
                new String[]{
                    "Ljava/lang/reflect/Constructor;",
                    "[Ljava/lang/Object;",
                },
                false
            );
        }

        @Override
        public final String[] getMethodNames() {
            return Target_sun_reflect_NativeConstructorAccessorImpl.SharedNativeConstructorAccessorImpl.INSTANCE.getMethodNames("newInstance0");
        }

        @Override
        public final String[] substitutionClassNames() {
            return Target_sun_reflect_NativeConstructorAccessorImpl.SharedNativeConstructorAccessorImpl.INSTANCE.substitutionClassNames();
        }

        @Override
        public final JavaSubstitution create() {
            return new Target_sun_reflect_NativeConstructorAccessorImpl_NewInstance0__LL();
        }

    }

    @Child private NewInstance0 node;

    @SuppressWarnings(value = "unused") private Target_sun_reflect_NativeConstructorAccessorImpl_NewInstance0__LL() {
        this.node = com.oracle.truffle.espresso.substitutions.Target_sun_reflect_NativeConstructorAccessorImplFactory.NewInstance0NodeGen.create();
    }

    @Override
    public final JavaSubstitution split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object[] args) {
        StaticObject arg0 = (StaticObject) args[0];
        StaticObject arg1 = (StaticObject) args[1];
        EspressoContext context = getContext();
        return this.node.execute(arg0, arg1, getLanguage(), context.getMeta());

    }

}

