/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Target_sun_reflect_NativeMethodAccessorImpl.Invoke0;
import com.oracle.truffle.espresso.runtime.EspressoContext;

/**
 * Generated by: {@link com.oracle.truffle.espresso.substitutions.Target_sun_reflect_NativeMethodAccessorImpl.Invoke0}
 */
public final class Target_sun_reflect_NativeMethodAccessorImpl_Invoke0__LLL extends JavaSubstitution {

    @Collect(value = com.oracle.truffle.espresso.substitutions.Substitution.class) public static final class Factory extends JavaSubstitution.Factory {

        public Factory() {
            super(
                "invoke0",
                "Target_sun_reflect_NativeMethodAccessorImpl",
                "Ljava/lang/Object;",
                new String[]{
                    "Ljava/lang/reflect/Method;",
                    "Ljava/lang/Object;",
                    "[Ljava/lang/Object;",
                },
                false
            );
        }

        @Override
        public final String[] getMethodNames() {
            return Target_sun_reflect_NativeMethodAccessorImpl.SharedNativeMetohdAccessorImpl.INSTANCE.getMethodNames("invoke0");
        }

        @Override
        public final String[] substitutionClassNames() {
            return Target_sun_reflect_NativeMethodAccessorImpl.SharedNativeMetohdAccessorImpl.INSTANCE.substitutionClassNames();
        }

        @Override
        public final JavaSubstitution create() {
            return new Target_sun_reflect_NativeMethodAccessorImpl_Invoke0__LLL();
        }

    }

    @Child private Invoke0 node;

    @SuppressWarnings(value = "unused") private Target_sun_reflect_NativeMethodAccessorImpl_Invoke0__LLL() {
        this.node = com.oracle.truffle.espresso.substitutions.Target_sun_reflect_NativeMethodAccessorImplFactory.Invoke0NodeGen.create();
    }

    @Override
    public final JavaSubstitution split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object[] args) {
        StaticObject arg0 = (StaticObject) args[0];
        StaticObject arg1 = (StaticObject) args[1];
        StaticObject arg2 = (StaticObject) args[2];
        EspressoContext context = getContext();
        return this.node.execute(arg0, arg1, arg2, getLanguage(), context.getMeta());

    }

}

