/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.substitutions.Collect;

/**
 * Generated by: {@link Management#GetOneThreadAllocatedMemory(long)}
 */
public final class Management_GetOneThreadAllocatedMemory__J extends CallableFromNative {

    @Collect(value = com.oracle.truffle.espresso.vm.ManagementImpl.class) public static final class Factory extends CallableFromNative.Factory {

        public Factory() {
            super(
                "GetOneThreadAllocatedMemory",
                NativeSignature.create(NativeType.LONG, NativeType.POINTER, NativeType.LONG),
                1,
                true
            );
        }

        @Override
        public final CallableFromNative create() {
            return new Management_GetOneThreadAllocatedMemory__J();
        }

    }

    @SuppressWarnings(value = "unused") private Management_GetOneThreadAllocatedMemory__J() {
    }

    @Override
    public final CallableFromNative split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object env, Object[] args) {
        com.oracle.truffle.api.TruffleSafepoint.poll(this);
        Management management = (Management) env;
        long arg0 = (long) args[1];
        return management.GetOneThreadAllocatedMemory(arg0);
    }

    @Override
    public final String generatedBy() {
        return "ManagementImpl";
    }

}

