/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.substitutions.Collect;

/**
 * Generated by: {@link VM#JVM_InitStackTraceElementArray(StaticObject, StaticObject, EspressoLanguage, Meta, SubstitutionProfiler)}
 */
public final class VM_JVM_InitStackTraceElementArray__LL extends CallableFromNative {

    @Collect(value = com.oracle.truffle.espresso.vm.VmImpl.class) public static final class Factory extends CallableFromNative.Factory {

        public Factory() {
            super(
                "JVM_InitStackTraceElementArray",
                NativeSignature.create(NativeType.VOID, NativeType.POINTER, NativeType.OBJECT, NativeType.OBJECT),
                2,
                true
            );
        }

        @Override
        public final CallableFromNative create() {
            return new VM_JVM_InitStackTraceElementArray__LL();
        }

    }

    @SuppressWarnings(value = "unused") private VM_JVM_InitStackTraceElementArray__LL() {
    }

    @Override
    public final CallableFromNative split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object env, Object[] args) {
        com.oracle.truffle.api.TruffleSafepoint.poll(this);
        VM vm = (VM) env;
        StaticObject arg0 = vm.getHandles().get(Math.toIntExact((long) args[1]));
        StaticObject arg1 = vm.getHandles().get(Math.toIntExact((long) args[2]));
        EspressoContext context = getContext();
        vm.JVM_InitStackTraceElementArray(arg0, arg1, getLanguage(), context.getMeta(), this);
        return StaticObject.NULL;
    }

    @Override
    public final Object invokeDirect(Object env, Object[] args) {
        com.oracle.truffle.api.TruffleSafepoint.poll(this);
        VM vm = (VM) env;
        StaticObject arg0 = (StaticObject) args[0];
        StaticObject arg1 = (StaticObject) args[1];
        EspressoContext context = getContext();
        vm.JVM_InitStackTraceElementArray(arg0, arg1, getLanguage(), context.getMeta(), this);
        return StaticObject.NULL;
    }

    @Override
    public final String generatedBy() {
        return "VmImpl";
    }

}

