/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.substitutions.Collect;

/**
 * Generated by: {@link VM#JVM_IsNaN(double)}
 */
public final class VM_JVM_IsNaN__D extends CallableFromNative {

    @Collect(value = com.oracle.truffle.espresso.vm.VmImpl.class) public static final class Factory extends CallableFromNative.Factory {

        public Factory() {
            super(
                "JVM_IsNaN",
                NativeSignature.create(NativeType.BOOLEAN, NativeType.DOUBLE),
                1,
                false
            );
        }

        @Override
        public final CallableFromNative create() {
            return new VM_JVM_IsNaN__D();
        }

    }

    @SuppressWarnings(value = "unused") private VM_JVM_IsNaN__D() {
    }

    @Override
    public final CallableFromNative split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object env, Object[] args) {
        double arg0 = (double) args[0];
        return VM.JVM_IsNaN(arg0);
    }

    @Override
    public final Object invokeDirect(Object env, Object[] args) {
        double arg0 = (double) args[0];
        return VM.JVM_IsNaN(arg0);
    }

    @Override
    public final String generatedBy() {
        return "VmImpl";
    }

}

