/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm.structs;

import java.nio.ByteBuffer;

import com.oracle.truffle.api.interop.TruffleObject;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.ffi.RawPointer;

@SuppressWarnings(value = "unused") public final class JvmtiEventCallbacks extends StructStorage<JvmtiEventCallbacks.JvmtiEventCallbacksWrapper> {

    final int VMInit;

    final int VMDeath;

    final int ThreadStart;

    final int ThreadEnd;

    final int ClassFileLoadHook;

    final int ClassLoad;

    final int ClassPrepare;

    final int VMStart;

    final int Exception;

    final int ExceptionCatch;

    final int SingleStep;

    final int FramePop;

    final int Breakpoint;

    final int FieldAccess;

    final int FieldModification;

    final int MethodEntry;

    final int MethodExit;

    final int NativeMethodBind;

    final int CompiledMethodLoad;

    final int CompiledMethodUnload;

    final int DynamicCodeGenerated;

    final int DataDumpRequest;

    final int reserved72;

    final int MonitorWait;

    final int MonitorWaited;

    final int MonitorContendedEnter;

    final int MonitorContendedEntered;

    final int reserved77;

    final int reserved78;

    final int reserved79;

    final int ResourceExhausted;

    final int GarbageCollectionStart;

    final int GarbageCollectionFinish;

    final int ObjectFree;

    final int VMObjectAlloc;

    final int reserved85;

    final int SampledObjectAlloc;

    JvmtiEventCallbacks(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiEventCallbacks"));
        VMInit = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "VMInit");
        VMDeath = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "VMDeath");
        ThreadStart = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "ThreadStart");
        ThreadEnd = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "ThreadEnd");
        ClassFileLoadHook = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "ClassFileLoadHook");
        ClassLoad = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "ClassLoad");
        ClassPrepare = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "ClassPrepare");
        VMStart = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "VMStart");
        Exception = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "Exception");
        ExceptionCatch = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "ExceptionCatch");
        SingleStep = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "SingleStep");
        FramePop = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "FramePop");
        Breakpoint = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "Breakpoint");
        FieldAccess = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "FieldAccess");
        FieldModification = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "FieldModification");
        MethodEntry = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "MethodEntry");
        MethodExit = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "MethodExit");
        NativeMethodBind = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "NativeMethodBind");
        CompiledMethodLoad = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "CompiledMethodLoad");
        CompiledMethodUnload = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "CompiledMethodUnload");
        DynamicCodeGenerated = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "DynamicCodeGenerated");
        DataDumpRequest = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "DataDumpRequest");
        reserved72 = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "reserved72");
        MonitorWait = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "MonitorWait");
        MonitorWaited = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "MonitorWaited");
        MonitorContendedEnter = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "MonitorContendedEnter");
        MonitorContendedEntered = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "MonitorContendedEntered");
        reserved77 = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "reserved77");
        reserved78 = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "reserved78");
        reserved79 = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "reserved79");
        ResourceExhausted = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "ResourceExhausted");
        GarbageCollectionStart = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "GarbageCollectionStart");
        GarbageCollectionFinish = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "GarbageCollectionFinish");
        ObjectFree = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "ObjectFree");
        VMObjectAlloc = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "VMObjectAlloc");
        reserved85 = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "reserved85");
        SampledObjectAlloc = (int) offsetGetter.getOffset("_jvmtiEventCallbacks", "SampledObjectAlloc");
    }

    public final class JvmtiEventCallbacksWrapper extends StructWrapper {

        JvmtiEventCallbacksWrapper(JniEnv jni, TruffleObject pointer) {
            super(jni, pointer, structSize);
        }

        public TruffleObject vmInit() {
            return getPointer(VMInit);
        }

        public void vmInit(TruffleObject valueToPut) {
            putPointer(VMInit, valueToPut);
        }

        public TruffleObject vmDeath() {
            return getPointer(VMDeath);
        }

        public void vmDeath(TruffleObject valueToPut) {
            putPointer(VMDeath, valueToPut);
        }

        public TruffleObject threadStart() {
            return getPointer(ThreadStart);
        }

        public void threadStart(TruffleObject valueToPut) {
            putPointer(ThreadStart, valueToPut);
        }

        public TruffleObject threadEnd() {
            return getPointer(ThreadEnd);
        }

        public void threadEnd(TruffleObject valueToPut) {
            putPointer(ThreadEnd, valueToPut);
        }

        public TruffleObject classFileLoadHook() {
            return getPointer(ClassFileLoadHook);
        }

        public void classFileLoadHook(TruffleObject valueToPut) {
            putPointer(ClassFileLoadHook, valueToPut);
        }

        public TruffleObject classLoad() {
            return getPointer(ClassLoad);
        }

        public void classLoad(TruffleObject valueToPut) {
            putPointer(ClassLoad, valueToPut);
        }

        public TruffleObject classPrepare() {
            return getPointer(ClassPrepare);
        }

        public void classPrepare(TruffleObject valueToPut) {
            putPointer(ClassPrepare, valueToPut);
        }

        public TruffleObject vmStart() {
            return getPointer(VMStart);
        }

        public void vmStart(TruffleObject valueToPut) {
            putPointer(VMStart, valueToPut);
        }

        public TruffleObject exception() {
            return getPointer(Exception);
        }

        public void exception(TruffleObject valueToPut) {
            putPointer(Exception, valueToPut);
        }

        public TruffleObject exceptionCatch() {
            return getPointer(ExceptionCatch);
        }

        public void exceptionCatch(TruffleObject valueToPut) {
            putPointer(ExceptionCatch, valueToPut);
        }

        public TruffleObject singleStep() {
            return getPointer(SingleStep);
        }

        public void singleStep(TruffleObject valueToPut) {
            putPointer(SingleStep, valueToPut);
        }

        public TruffleObject framePop() {
            return getPointer(FramePop);
        }

        public void framePop(TruffleObject valueToPut) {
            putPointer(FramePop, valueToPut);
        }

        public TruffleObject breakpoint() {
            return getPointer(Breakpoint);
        }

        public void breakpoint(TruffleObject valueToPut) {
            putPointer(Breakpoint, valueToPut);
        }

        public TruffleObject fieldAccess() {
            return getPointer(FieldAccess);
        }

        public void fieldAccess(TruffleObject valueToPut) {
            putPointer(FieldAccess, valueToPut);
        }

        public TruffleObject fieldModification() {
            return getPointer(FieldModification);
        }

        public void fieldModification(TruffleObject valueToPut) {
            putPointer(FieldModification, valueToPut);
        }

        public TruffleObject methodEntry() {
            return getPointer(MethodEntry);
        }

        public void methodEntry(TruffleObject valueToPut) {
            putPointer(MethodEntry, valueToPut);
        }

        public TruffleObject methodExit() {
            return getPointer(MethodExit);
        }

        public void methodExit(TruffleObject valueToPut) {
            putPointer(MethodExit, valueToPut);
        }

        public TruffleObject nativeMethodBind() {
            return getPointer(NativeMethodBind);
        }

        public void nativeMethodBind(TruffleObject valueToPut) {
            putPointer(NativeMethodBind, valueToPut);
        }

        public TruffleObject compiledMethodLoad() {
            return getPointer(CompiledMethodLoad);
        }

        public void compiledMethodLoad(TruffleObject valueToPut) {
            putPointer(CompiledMethodLoad, valueToPut);
        }

        public TruffleObject compiledMethodUnload() {
            return getPointer(CompiledMethodUnload);
        }

        public void compiledMethodUnload(TruffleObject valueToPut) {
            putPointer(CompiledMethodUnload, valueToPut);
        }

        public TruffleObject dynamicCodeGenerated() {
            return getPointer(DynamicCodeGenerated);
        }

        public void dynamicCodeGenerated(TruffleObject valueToPut) {
            putPointer(DynamicCodeGenerated, valueToPut);
        }

        public TruffleObject dataDumpRequest() {
            return getPointer(DataDumpRequest);
        }

        public void dataDumpRequest(TruffleObject valueToPut) {
            putPointer(DataDumpRequest, valueToPut);
        }

        public TruffleObject reserved72() {
            return getPointer(reserved72);
        }

        public void reserved72(TruffleObject valueToPut) {
            putPointer(reserved72, valueToPut);
        }

        public TruffleObject monitorWait() {
            return getPointer(MonitorWait);
        }

        public void monitorWait(TruffleObject valueToPut) {
            putPointer(MonitorWait, valueToPut);
        }

        public TruffleObject monitorWaited() {
            return getPointer(MonitorWaited);
        }

        public void monitorWaited(TruffleObject valueToPut) {
            putPointer(MonitorWaited, valueToPut);
        }

        public TruffleObject monitorContendedEnter() {
            return getPointer(MonitorContendedEnter);
        }

        public void monitorContendedEnter(TruffleObject valueToPut) {
            putPointer(MonitorContendedEnter, valueToPut);
        }

        public TruffleObject monitorContendedEntered() {
            return getPointer(MonitorContendedEntered);
        }

        public void monitorContendedEntered(TruffleObject valueToPut) {
            putPointer(MonitorContendedEntered, valueToPut);
        }

        public TruffleObject reserved77() {
            return getPointer(reserved77);
        }

        public void reserved77(TruffleObject valueToPut) {
            putPointer(reserved77, valueToPut);
        }

        public TruffleObject reserved78() {
            return getPointer(reserved78);
        }

        public void reserved78(TruffleObject valueToPut) {
            putPointer(reserved78, valueToPut);
        }

        public TruffleObject reserved79() {
            return getPointer(reserved79);
        }

        public void reserved79(TruffleObject valueToPut) {
            putPointer(reserved79, valueToPut);
        }

        public TruffleObject resourceExhausted() {
            return getPointer(ResourceExhausted);
        }

        public void resourceExhausted(TruffleObject valueToPut) {
            putPointer(ResourceExhausted, valueToPut);
        }

        public TruffleObject garbageCollectionStart() {
            return getPointer(GarbageCollectionStart);
        }

        public void garbageCollectionStart(TruffleObject valueToPut) {
            putPointer(GarbageCollectionStart, valueToPut);
        }

        public TruffleObject garbageCollectionFinish() {
            return getPointer(GarbageCollectionFinish);
        }

        public void garbageCollectionFinish(TruffleObject valueToPut) {
            putPointer(GarbageCollectionFinish, valueToPut);
        }

        public TruffleObject objectFree() {
            return getPointer(ObjectFree);
        }

        public void objectFree(TruffleObject valueToPut) {
            putPointer(ObjectFree, valueToPut);
        }

        public TruffleObject vmObjectAlloc() {
            return getPointer(VMObjectAlloc);
        }

        public void vmObjectAlloc(TruffleObject valueToPut) {
            putPointer(VMObjectAlloc, valueToPut);
        }

        public TruffleObject reserved85() {
            return getPointer(reserved85);
        }

        public void reserved85(TruffleObject valueToPut) {
            putPointer(reserved85, valueToPut);
        }

        public TruffleObject sampledObjectAlloc() {
            return getPointer(SampledObjectAlloc);
        }

        public void sampledObjectAlloc(TruffleObject valueToPut) {
            putPointer(SampledObjectAlloc, valueToPut);
        }

    }

    @Override
    public JvmtiEventCallbacksWrapper wrap(JniEnv jni, TruffleObject pointer) {
        return new JvmtiEventCallbacksWrapper(jni, pointer);
    }

}

