/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm.structs;

import java.nio.ByteBuffer;

import com.oracle.truffle.api.interop.TruffleObject;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.ffi.RawPointer;

@SuppressWarnings(value = "unused") public final class JvmtiHeapReferenceInfoReserved extends StructStorage<JvmtiHeapReferenceInfoReserved.JvmtiHeapReferenceInfoReservedWrapper> {

    final int reserved1;

    final int reserved2;

    final int reserved3;

    final int reserved4;

    final int reserved5;

    final int reserved6;

    final int reserved7;

    final int reserved8;

    JvmtiHeapReferenceInfoReserved(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiHeapReferenceInfoReserved"));
        reserved1 = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoReserved", "reserved1");
        reserved2 = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoReserved", "reserved2");
        reserved3 = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoReserved", "reserved3");
        reserved4 = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoReserved", "reserved4");
        reserved5 = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoReserved", "reserved5");
        reserved6 = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoReserved", "reserved6");
        reserved7 = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoReserved", "reserved7");
        reserved8 = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoReserved", "reserved8");
    }

    public final class JvmtiHeapReferenceInfoReservedWrapper extends StructWrapper {

        JvmtiHeapReferenceInfoReservedWrapper(JniEnv jni, TruffleObject pointer) {
            super(jni, pointer, structSize);
        }

        public long reserved1() {
            return getLong(reserved1);
        }

        public void reserved1(long valueToPut) {
            putLong(reserved1, valueToPut);
        }

        public long reserved2() {
            return getLong(reserved2);
        }

        public void reserved2(long valueToPut) {
            putLong(reserved2, valueToPut);
        }

        public long reserved3() {
            return getLong(reserved3);
        }

        public void reserved3(long valueToPut) {
            putLong(reserved3, valueToPut);
        }

        public long reserved4() {
            return getLong(reserved4);
        }

        public void reserved4(long valueToPut) {
            putLong(reserved4, valueToPut);
        }

        public long reserved5() {
            return getLong(reserved5);
        }

        public void reserved5(long valueToPut) {
            putLong(reserved5, valueToPut);
        }

        public long reserved6() {
            return getLong(reserved6);
        }

        public void reserved6(long valueToPut) {
            putLong(reserved6, valueToPut);
        }

        public long reserved7() {
            return getLong(reserved7);
        }

        public void reserved7(long valueToPut) {
            putLong(reserved7, valueToPut);
        }

        public long reserved8() {
            return getLong(reserved8);
        }

        public void reserved8(long valueToPut) {
            putLong(reserved8, valueToPut);
        }

    }

    @Override
    public JvmtiHeapReferenceInfoReservedWrapper wrap(JniEnv jni, TruffleObject pointer) {
        return new JvmtiHeapReferenceInfoReservedWrapper(jni, pointer);
    }

}

