/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm.structs;

import java.nio.ByteBuffer;

import com.oracle.truffle.api.interop.TruffleObject;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.ffi.RawPointer;

@SuppressWarnings(value = "unused") public final class JvmtiMonitorStackDepthInfo extends StructStorage<JvmtiMonitorStackDepthInfo.JvmtiMonitorStackDepthInfoWrapper> {

    final int monitor;

    final int stack_depth;

    JvmtiMonitorStackDepthInfo(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiMonitorStackDepthInfo"));
        monitor = (int) offsetGetter.getOffset("_jvmtiMonitorStackDepthInfo", "monitor");
        stack_depth = (int) offsetGetter.getOffset("_jvmtiMonitorStackDepthInfo", "stack_depth");
    }

    public final class JvmtiMonitorStackDepthInfoWrapper extends StructWrapper {

        JvmtiMonitorStackDepthInfoWrapper(JniEnv jni, TruffleObject pointer) {
            super(jni, pointer, structSize);
        }

        public StaticObject monitor() {
            return getObject(monitor);
        }

        public void monitor(StaticObject valueToPut) {
            putObject(monitor, valueToPut);
        }

        public int stackDepth() {
            return getInt(stack_depth);
        }

        public void stackDepth(int valueToPut) {
            putInt(stack_depth, valueToPut);
        }

    }

    @Override
    public JvmtiMonitorStackDepthInfoWrapper wrap(JniEnv jni, TruffleObject pointer) {
        return new JvmtiMonitorStackDepthInfoWrapper(jni, pointer);
    }

}

