/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm.structs;

import java.nio.ByteBuffer;

import com.oracle.truffle.api.interop.TruffleObject;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.ffi.RawPointer;

@SuppressWarnings(value = "unused") public final class JvmtiParamInfo extends StructStorage<JvmtiParamInfo.JvmtiParamInfoWrapper> {

    final int name;

    final int kind;

    final int base_type;

    final int null_ok;

    JvmtiParamInfo(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiParamInfo"));
        name = (int) offsetGetter.getOffset("_jvmtiParamInfo", "name");
        kind = (int) offsetGetter.getOffset("_jvmtiParamInfo", "kind");
        base_type = (int) offsetGetter.getOffset("_jvmtiParamInfo", "base_type");
        null_ok = (int) offsetGetter.getOffset("_jvmtiParamInfo", "null_ok");
    }

    public final class JvmtiParamInfoWrapper extends StructWrapper {

        JvmtiParamInfoWrapper(JniEnv jni, TruffleObject pointer) {
            super(jni, pointer, structSize);
        }

        public TruffleObject name() {
            return getPointer(name);
        }

        public void name(TruffleObject valueToPut) {
            putPointer(name, valueToPut);
        }

        public int kind() {
            return getInt(kind);
        }

        public void kind(int valueToPut) {
            putInt(kind, valueToPut);
        }

        public int baseType() {
            return getInt(base_type);
        }

        public void baseType(int valueToPut) {
            putInt(base_type, valueToPut);
        }

        public boolean nullOk() {
            return getBoolean(null_ok);
        }

        public void nullOk(boolean valueToPut) {
            putBoolean(null_ok, valueToPut);
        }

    }

    @Override
    public JvmtiParamInfoWrapper wrap(JniEnv jni, TruffleObject pointer) {
        return new JvmtiParamInfoWrapper(jni, pointer);
    }

}

