/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.liveness;

import com.oracle.truffle.espresso.analysis.liveness.Record;
import java.util.Arrays;
import java.util.Iterator;

public final class History
implements Iterable<Record> {
    private static final int DEFAULT_CAPACITY = 2;
    private Record[] history = new Record[this.capacity];
    private int size = 0;
    private int capacity = 2;

    public void add(Record record) {
        if (this.size == this.capacity) {
            this.history = Arrays.copyOf(this.history, this.capacity <<= 1);
        }
        this.history[this.size] = record;
        ++this.size;
    }

    @Override
    public Iterator<Record> iterator() {
        return new OrderedIterator();
    }

    public Iterable<Record> reverse() {
        return new ReverseIterator();
    }

    private class OrderedIterator
    implements Iterator<Record> {
        private int pos = 0;

        private OrderedIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < History.this.size;
        }

        @Override
        public Record next() {
            return History.this.history[this.pos++];
        }
    }

    private class ReverseIterator
    implements Iterable<Record>,
    Iterator<Record> {
        private int pos;

        private ReverseIterator() {
            this.pos = History.this.size - 1;
        }

        @Override
        public boolean hasNext() {
            return this.pos >= 0;
        }

        @Override
        public Record next() {
            return History.this.history[this.pos--];
        }

        @Override
        public Iterator<Record> iterator() {
            return this;
        }
    }
}

