/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile;

import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.ClasspathFile;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class ClassfileStream {
    private final ClasspathFile classfile;
    private final ByteBuffer data;
    private final byte[] bytes;

    public ClassfileStream(byte[] bytes, ClasspathFile classfile) {
        this.bytes = bytes;
        this.data = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
        this.classfile = classfile;
    }

    public char readChar() {
        try {
            return this.data.getChar();
        }
        catch (BufferUnderflowException e) {
            throw this.eofError();
        }
    }

    public float readFloat() {
        try {
            return this.data.getFloat();
        }
        catch (BufferUnderflowException e) {
            throw this.eofError();
        }
    }

    public long readS8() {
        try {
            return this.data.getLong();
        }
        catch (BufferUnderflowException e) {
            throw this.eofError();
        }
    }

    public double readDouble() {
        try {
            return this.data.getDouble();
        }
        catch (BufferUnderflowException e) {
            throw this.eofError();
        }
    }

    public int readU1() {
        try {
            return this.data.get() & 0xFF;
        }
        catch (BufferUnderflowException e) {
            throw this.eofError();
        }
    }

    public int readU2() {
        try {
            return this.data.getChar();
        }
        catch (BufferUnderflowException e) {
            throw this.eofError();
        }
    }

    public int readS4() {
        try {
            return this.data.getInt();
        }
        catch (BufferUnderflowException e) {
            throw this.eofError();
        }
    }

    public int readS1() {
        try {
            return this.data.get();
        }
        catch (BufferUnderflowException e) {
            throw this.eofError();
        }
    }

    public int readS2() {
        try {
            return this.data.getShort();
        }
        catch (BufferUnderflowException e) {
            throw this.eofError();
        }
    }

    public byte[] readByteArray(int len) {
        try {
            byte[] buf = new byte[len];
            this.data.get(buf);
            return buf;
        }
        catch (BufferUnderflowException e) {
            throw this.eofError();
        }
    }

    public ByteSequence readByteSequenceUTF() {
        int utflen = this.readU2();
        int start = this.getPosition();
        this.skip(utflen);
        return ByteSequence.wrap(this.bytes, start, utflen);
    }

    public void skip(int nBytes) {
        try {
            this.data.position(this.data.position() + nBytes);
        }
        catch (IllegalArgumentException e) {
            throw this.eofError();
        }
    }

    byte[] getByteRange(int startPosition, int numBytes) {
        try {
            byte[] result = new byte[numBytes];
            System.arraycopy(this.bytes, startPosition, result, 0, numBytes);
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.eofError();
        }
    }

    public boolean isAtEndOfFile() {
        return this.data.remaining() == 0;
    }

    public void checkEndOfFile() {
        if (!this.isAtEndOfFile()) {
            throw this.classFormatError("Extra bytes", this.classfile);
        }
    }

    public int getPosition() {
        return this.data.position();
    }

    public ClassFormatError classFormatError(String format, Object ... args) {
        Meta meta = EspressoContext.get(null).getMeta();
        if (meta.java_lang_ClassFormatError == null) {
            throw EspressoError.fatal("ClassFormatError during early startup: " + String.format(format, args) + " in classfile " + this.classfile);
        }
        throw meta.throwExceptionWithMessage(meta.java_lang_ClassFormatError, String.format(format, args) + " in classfile " + this.classfile);
    }

    public ClassFormatError ioError(IOException ioException) {
        throw this.classFormatError("%s", ioException);
    }

    public ClassFormatError eofError() {
        throw this.classFormatError("Truncated class file", new Object[0]);
    }
}

