/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.attributes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.Attribute;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class BootstrapMethodsAttribute
extends Attribute {
    public static final Symbol<Symbol.Name> NAME = Symbol.Name.BootstrapMethods;
    private final Entry[] entries;

    public Entry[] getEntries() {
        return this.entries;
    }

    public BootstrapMethodsAttribute(Symbol<Symbol.Name> name, Entry[] entries) {
        super(name, null);
        this.entries = entries;
    }

    public Entry at(int index) {
        return this.entries[index];
    }

    public static final class Entry {
        final char bootstrapMethodRef;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final char[] bootstrapArguments;

        public int numBootstrapArguments() {
            return this.bootstrapArguments.length;
        }

        public Entry(char bootstrapMethodRef, char[] bootstrapArguments) {
            this.bootstrapMethodRef = bootstrapMethodRef;
            this.bootstrapArguments = bootstrapArguments;
        }

        public char argAt(int index) {
            return this.bootstrapArguments[index];
        }

        public char getBootstrapMethodRef() {
            return this.bootstrapMethodRef;
        }

        public StaticObject getMethodHandle(Klass accessingKlass, RuntimeConstantPool pool) {
            return pool.resolvedMethodHandleAt(accessingKlass, this.getBootstrapMethodRef());
        }

        public StaticObject[] getStaticArguments(Klass accessingKlass, RuntimeConstantPool pool) {
            Meta meta = accessingKlass.getMeta();
            StaticObject[] args = new StaticObject[this.numBootstrapArguments()];
            block11: for (int i = 0; i < this.numBootstrapArguments(); ++i) {
                PoolConstant pc = pool.at(this.argAt(i));
                switch (pc.tag()) {
                    case METHODHANDLE: {
                        args[i] = pool.resolvedMethodHandleAt(accessingKlass, this.argAt(i));
                        continue block11;
                    }
                    case METHODTYPE: {
                        args[i] = pool.resolvedMethodTypeAt(accessingKlass, this.argAt(i));
                        continue block11;
                    }
                    case DYNAMIC: {
                        args[i] = pool.resolvedDynamicConstantAt(accessingKlass, this.argAt(i)).guestBoxedValue(meta);
                        continue block11;
                    }
                    case CLASS: {
                        args[i] = pool.resolvedKlassAt(accessingKlass, this.argAt(i)).mirror();
                        continue block11;
                    }
                    case STRING: {
                        args[i] = pool.resolvedStringAt(this.argAt(i));
                        continue block11;
                    }
                    case INTEGER: {
                        args[i] = meta.boxInteger(pool.intAt(this.argAt(i)));
                        continue block11;
                    }
                    case LONG: {
                        args[i] = meta.boxLong(pool.longAt(this.argAt(i)));
                        continue block11;
                    }
                    case DOUBLE: {
                        args[i] = meta.boxDouble(pool.doubleAt(this.argAt(i)));
                        continue block11;
                    }
                    case FLOAT: {
                        args[i] = meta.boxFloat(pool.floatAt(this.argAt(i)));
                        continue block11;
                    }
                    default: {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw EspressoError.shouldNotReachHere();
                    }
                }
            }
            return args;
        }
    }
}

