/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.MemberRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.util.Objects;

public interface InterfaceMethodRefConstant
extends MethodRefConstant {
    public static InterfaceMethodRefConstant create(int classIndex, int nameAndTypeIndex) {
        return new Indexes(classIndex, nameAndTypeIndex);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.INTERFACE_METHOD_REF;
    }

    public static final class Indexes
    extends MethodRefConstant.Indexes
    implements InterfaceMethodRefConstant,
    Resolvable {
        Indexes(int classIndex, int nameAndTypeIndex) {
            super(classIndex, nameAndTypeIndex);
        }

        @Override
        public Resolvable.ResolvedConstant resolve(RuntimeConstantPool pool, int thisIndex, Klass accessingKlass) {
            METHODREF_RESOLVE_COUNT.inc();
            EspressoContext context = pool.getContext();
            Meta meta = context.getMeta();
            Klass holderInterface = this.getResolvedHolderKlass(accessingKlass, pool);
            Symbol<Symbol.Name> name = this.getName(pool);
            if (!holderInterface.isInterface()) {
                throw meta.throwExceptionWithMessage(meta.java_lang_IncompatibleClassChangeError, meta.toGuestString(name));
            }
            Symbol<Symbol.Signature> signature = this.getSignature(pool);
            Method method = ((ObjectKlass)holderInterface).resolveInterfaceMethod(name, signature);
            if (method == null) {
                throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchMethodError, meta.toGuestString(name));
            }
            MemberRefConstant.doAccessCheck(accessingKlass, holderInterface, method, meta);
            method.checkLoadingConstraints(accessingKlass.getDefiningClassLoader(), method.getDeclaringKlass().getDefiningClassLoader());
            return new Resolved(method);
        }
    }

    public static final class Resolved
    implements InterfaceMethodRefConstant,
    Resolvable.ResolvedConstant {
        private final Method resolved;

        Resolved(Method resolved) {
            this.resolved = Objects.requireNonNull(resolved);
        }

        @Override
        public Method value() {
            return this.resolved;
        }

        @Override
        public Symbol<Symbol.Name> getHolderKlassName(ConstantPool pool) {
            throw EspressoError.shouldNotReachHere("Method already resolved");
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return this.resolved.getName();
        }

        @Override
        public Symbol<? extends Symbol.Descriptor> getDescriptor(ConstantPool pool) {
            return this.resolved.getRawSignature();
        }
    }
}

