/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.descriptors;

import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Symbols;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.meta.JavaKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class Signatures {
    private final Types types;
    private final Symbols symbols;
    private final ConcurrentHashMap<Symbol<Symbol.Signature>, Symbol<Symbol.Type>[]> parsedSignatures = new ConcurrentHashMap();

    public Signatures(Symbols symbols, Types types) {
        this.symbols = symbols;
        this.types = types;
    }

    public Symbol<Symbol.Signature> toBasic(Symbol<Symbol.Signature> raw, boolean keepLastArg) {
        Symbol<Symbol.Type>[] sig = this.parsed(raw);
        int pcount = Signatures.parameterCount(sig);
        int params = Math.max(pcount - (keepLastArg ? 0 : 1), 0);
        ArrayList<Symbol<Symbol.Type>> buf = new ArrayList<Symbol<Symbol.Type>>();
        for (int i = 0; i < params; ++i) {
            Symbol<Symbol.Type> t = Signatures.parameterType(sig, i);
            if (i == params - 1 && keepLastArg) {
                buf.add(t);
                continue;
            }
            buf.add(Signatures.toBasic(t));
        }
        Symbol<Symbol.Type> rtype = Signatures.toBasic(Signatures.returnType(sig));
        return this.makeRaw(rtype, buf.toArray(Symbol.EMPTY_ARRAY));
    }

    private static Symbol<Symbol.Type> toBasic(Symbol<Symbol.Type> t) {
        if (t == Symbol.Type.java_lang_Object || Types.isArray(t)) {
            return Symbol.Type.java_lang_Object;
        }
        if (t == Symbol.Type._int || t == Symbol.Type._short || t == Symbol.Type._boolean || t == Symbol.Type._char) {
            return Symbol.Type._int;
        }
        return t;
    }

    public Symbol<Symbol.Signature> lookupValidSignature(String signatureString) {
        if (!Signatures.isValid(signatureString)) {
            return null;
        }
        return this.symbols.lookup(signatureString);
    }

    public Symbol<Symbol.Signature> symbolifyValidSignature(String signatureString) {
        if (!Signatures.isValid(signatureString)) {
            return null;
        }
        return this.symbols.symbolify(ByteSequence.create(signatureString));
    }

    public Types getTypes() {
        return this.types;
    }

    static Symbol<Symbol.Type>[] parse(Types typeDescriptors, Symbol<Symbol.Signature> signature, int startIndex) throws ClassFormatError {
        Symbol<Symbol.Type> descriptor;
        if (startIndex > signature.length() - 3 || signature.byteAt(startIndex) != 40) {
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
        ArrayList<Symbol<Symbol.Type>> buf = new ArrayList<Symbol<Symbol.Type>>();
        int i = startIndex + 1;
        while (signature.byteAt(i) != 41) {
            descriptor = typeDescriptors.parse(signature, i, true);
            buf.add(descriptor);
            if ((i += descriptor.length()) < signature.length()) continue;
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
        if (++i + (descriptor = typeDescriptors.parse(signature, i, true)).length() != signature.length()) {
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
        Symbol[] descriptors = buf.toArray(new Symbol[buf.size() + 1]);
        descriptors[buf.size()] = descriptor;
        return descriptors;
    }

    public static int skipValidSignature(Symbol<Symbol.Signature> signature, int beginIndex) throws ClassFormatError {
        if (beginIndex > signature.length() - 3 || signature.byteAt(beginIndex) != 40) {
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
        int i = beginIndex + 1;
        while (signature.byteAt(i) != 41) {
            int endIndex = Types.skipValidTypeDescriptor(signature, i, true);
            if (i >= signature.length()) {
                throw new ClassFormatError("Invalid method signature: " + signature);
            }
            i = endIndex;
        }
        return Types.skipValidTypeDescriptor(signature, ++i, true);
    }

    public static Symbol<Symbol.Signature> check(Symbol<? extends Symbol.Descriptor> descriptor) {
        assert (Signatures.isValid(descriptor));
        return descriptor;
    }

    public static Symbol<Symbol.Type> returnType(Symbol<Symbol.Type>[] signature) {
        return signature[signature.length - 1];
    }

    public static JavaKind returnKind(Symbol<Symbol.Type>[] signature) {
        return Types.getJavaKind(Signatures.returnType(signature));
    }

    public static int getNumberOfSlots(Symbol<Symbol.Type>[] signature) {
        int slots = 0;
        for (Symbol<Symbol.Type> type : signature) {
            slots += Types.getJavaKind(type).getSlotCount();
        }
        return slots;
    }

    @ExplodeLoop
    public static int slotsForParameters(Symbol<Symbol.Type>[] signature) {
        int slots = 0;
        int count = Signatures.parameterCount(signature);
        for (int i = 0; i < count; ++i) {
            slots += Signatures.parameterKind(signature, i).getSlotCount();
        }
        return slots;
    }

    public static int parameterCount(Symbol<Symbol.Type>[] signature) {
        return signature.length - 1;
    }

    public static boolean isValid(Symbol<Symbol.Signature> signature) {
        int endIndex = Signatures.skipValidSignature(signature, 0);
        return endIndex == signature.length();
    }

    public static boolean isValid(String signatureString) {
        return true;
    }

    public static Symbol<Symbol.Signature> verify(Symbol<Symbol.Signature> signature) {
        int endIndex = Signatures.skipValidSignature(signature, 0);
        if (endIndex != signature.length()) {
            throw new ClassFormatError("Invalid signature descriptor " + signature);
        }
        return signature;
    }

    public static JavaKind parameterKind(Symbol<Symbol.Type>[] signature, int paramIndex) {
        return Types.getJavaKind(signature[paramIndex]);
    }

    public static Symbol<Symbol.Type> parameterType(Symbol<Symbol.Type>[] signature, int paramIndex) {
        assert (paramIndex + 1 < signature.length);
        return signature[paramIndex];
    }

    @SafeVarargs
    public static final Symbol<Symbol.Type>[] makeParsedUncached(Symbol<Symbol.Type> returnType, Symbol<Symbol.Type> ... parameterTypes) {
        Symbol<Symbol.Type>[] signature = Arrays.copyOf(parameterTypes, parameterTypes.length + 1);
        signature[signature.length - 1] = returnType;
        return signature;
    }

    public Symbol<Symbol.Signature> makeRaw(Class<?> returnClass, Class<?> ... parameterClasses) {
        Symbol[] parameterTypes = new Symbol[parameterClasses.length];
        for (int i = 0; i < parameterClasses.length; ++i) {
            parameterTypes[i] = this.getTypes().fromClass(parameterClasses[i]);
        }
        return this.makeRaw(this.getTypes().fromClass(returnClass), parameterTypes);
    }

    @SafeVarargs
    public final Symbol<Symbol.Signature> makeRaw(Symbol<Symbol.Type> returnType, Symbol<Symbol.Type> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            byte[] bytes = new byte[2 + returnType.length()];
            Symbol.copyBytes(returnType, 0, bytes, 2, returnType.length());
            bytes[0] = 40;
            bytes[1] = 41;
            return this.symbols.symbolify(ByteSequence.wrap(bytes));
        }
        int totalLength = returnType.length();
        for (Symbol<Symbol.Type> param : parameterTypes) {
            totalLength += param.length();
        }
        byte[] bytes = new byte[totalLength + 2];
        int pos = 0;
        bytes[pos++] = 40;
        for (Symbol<Symbol.Type> param : parameterTypes) {
            Symbol.copyBytes(param, 0, bytes, pos, param.length());
            pos += param.length();
        }
        bytes[pos++] = 41;
        Symbol.copyBytes(returnType, 0, bytes, pos, returnType.length());
        assert ((pos += returnType.length()) == totalLength + 2);
        return this.symbols.symbolify(ByteSequence.wrap(bytes));
    }

    public Symbol<Symbol.Signature> getOrCreateValidSignature(String signatureString) {
        return this.symbols.symbolify(ByteSequence.create(Signatures.checkSignature(signatureString)));
    }

    private static String checkSignature(String signatureString) {
        return signatureString;
    }

    @SafeVarargs
    static byte[] buildSignatureBytes(Symbol<Symbol.Type> returnType, Symbol<Symbol.Type> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            byte[] bytes = new byte[2 + returnType.length()];
            bytes[0] = 40;
            bytes[1] = 41;
            Symbol.copyBytes(returnType, 0, bytes, 2, returnType.length());
            return bytes;
        }
        int totalLength = returnType.length();
        for (Symbol<Symbol.Type> param : parameterTypes) {
            totalLength += param.length();
        }
        byte[] bytes = new byte[totalLength + 2];
        int pos = 0;
        bytes[pos++] = 40;
        for (Symbol<Symbol.Type> param : parameterTypes) {
            Symbol.copyBytes(param, 0, bytes, pos, param.length());
            pos += param.length();
        }
        bytes[pos++] = 41;
        Symbol.copyBytes(returnType, 0, bytes, pos, returnType.length());
        assert ((pos += returnType.length()) == totalLength + 2);
        return bytes;
    }

    public Symbol<Symbol.Type>[] parsed(final Symbol<Symbol.Signature> signature) {
        return this.parsedSignatures.computeIfAbsent(signature, new Function<Symbol<Symbol.Signature>, Symbol<Symbol.Type>[]>(){

            @Override
            public Symbol<Symbol.Type>[] apply(Symbol<Symbol.Signature> key) {
                return Signatures.parse(Signatures.this.getTypes(), signature, 0);
            }
        });
    }
}

