/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.ffi.Buffer;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.meta.JavaKind;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@ExportLibrary(value=InteropLibrary.class)
public final class TruffleByteBuffer
implements TruffleObject {
    private final ByteBuffer byteBuffer;

    private TruffleByteBuffer(@Pointer TruffleObject addressPtr, long byteCapacity) {
        if (byteCapacity < 0L) {
            throw new IllegalArgumentException("negative requested capacity");
        }
        this.byteBuffer = NativeUtils.directByteBuffer(NativeUtils.interopAsPointer(addressPtr), byteCapacity);
    }

    private TruffleByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = Objects.requireNonNull(byteBuffer);
    }

    public static @Buffer TruffleObject create(ByteBuffer byteBuffer) {
        return new TruffleByteBuffer(byteBuffer);
    }

    public static @Buffer TruffleObject create(@Pointer TruffleObject addressPtr, long size, JavaKind kind) {
        long byteCapacity = Math.multiplyExact(size, kind.getByteCount());
        return new TruffleByteBuffer(addressPtr, byteCapacity);
    }

    @CompilerDirectives.TruffleBoundary
    public static @Buffer TruffleObject allocateDirectStringUTF8(String string) {
        return TruffleByteBuffer.allocateDirectString(string, StandardCharsets.UTF_8);
    }

    @CompilerDirectives.TruffleBoundary
    public static @Buffer TruffleObject allocateDirectString(String string, Charset charset) {
        byte[] bytes = string.getBytes(charset);
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length + 1);
        buffer.put(bytes);
        buffer.put((byte)0);
        return TruffleByteBuffer.create(buffer);
    }

    public static @Buffer TruffleObject allocate(int byteCapacity) {
        return TruffleByteBuffer.create(ByteBuffer.allocate(byteCapacity));
    }

    public static @Buffer TruffleObject allocateDirect(int byteCapacity) {
        return TruffleByteBuffer.create(ByteBuffer.allocateDirect(byteCapacity));
    }

    public static @Buffer TruffleObject wrap(@Pointer TruffleObject address, int byteCapacity) {
        assert (InteropLibrary.getUncached().isPointer((Object)address));
        return TruffleByteBuffer.create(NativeUtils.directByteBuffer(address, (long)byteCapacity));
    }

    public static @Buffer TruffleObject wrap(@Pointer TruffleObject addressPtr, int elemCount, JavaKind kind) {
        return TruffleByteBuffer.wrap(addressPtr, Math.multiplyExact(elemCount, kind.getByteCount()));
    }

    @ExportMessage
    boolean isPointer() {
        return this.byteBuffer.isDirect();
    }

    @ExportMessage
    long asPointer() throws UnsupportedMessageException {
        if (!this.isPointer()) {
            throw UnsupportedMessageException.create();
        }
        return NativeUtils.byteBufferAddress(this.byteBuffer);
    }

    @ExportMessage
    boolean hasBufferElements() {
        return true;
    }

    @ExportMessage
    long getBufferSize() {
        return this.byteBuffer.capacity();
    }

    @ExportMessage
    boolean isBufferWritable() {
        return !this.byteBuffer.isReadOnly();
    }

    @ExportMessage
    byte readBufferByte(long byteOffset, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            return TruffleByteBuffer.readByte(this.byteBuffer, index);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
    }

    @ExportMessage
    void writeBufferByte(long byteOffset, byte value, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            TruffleByteBuffer.writeByte(this.byteBuffer, index, value);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
        catch (ReadOnlyBufferException e) {
            error.enter();
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    short readBufferShort(ByteOrder order, long byteOffset, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            return TruffleByteBuffer.readShort(this.byteBuffer, order, index);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
    }

    @ExportMessage
    void writeBufferShort(ByteOrder order, long byteOffset, short value, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            TruffleByteBuffer.writeShort(this.byteBuffer, order, index, value);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
        catch (ReadOnlyBufferException e) {
            error.enter();
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    int readBufferInt(ByteOrder order, long byteOffset, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            return TruffleByteBuffer.readInt(this.byteBuffer, order, index);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
    }

    @ExportMessage
    void writeBufferInt(ByteOrder order, long byteOffset, int value, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            TruffleByteBuffer.writeInt(this.byteBuffer, order, index, value);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
        catch (ReadOnlyBufferException e) {
            error.enter();
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    long readBufferLong(ByteOrder order, long byteOffset, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            return TruffleByteBuffer.readLong(this.byteBuffer, order, index);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
    }

    @ExportMessage
    void writeBufferLong(ByteOrder order, long byteOffset, long value, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            TruffleByteBuffer.writeLong(this.byteBuffer, order, index, value);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
        catch (ReadOnlyBufferException e) {
            error.enter();
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    float readBufferFloat(ByteOrder order, long byteOffset, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            return TruffleByteBuffer.readFloat(this.byteBuffer, order, index);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
    }

    @ExportMessage
    void writeBufferFloat(ByteOrder order, long byteOffset, float value, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            TruffleByteBuffer.writeFloat(this.byteBuffer, order, index, value);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
        catch (ReadOnlyBufferException e) {
            error.enter();
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    double readBufferDouble(ByteOrder order, long byteOffset, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            return TruffleByteBuffer.readDouble(this.byteBuffer, order, index);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
    }

    @ExportMessage
    void writeBufferDouble(ByteOrder order, long byteOffset, double value, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        try {
            int index = Math.toIntExact(byteOffset);
            TruffleByteBuffer.writeDouble(this.byteBuffer, order, index, value);
        }
        catch (ArithmeticException | IndexOutOfBoundsException e) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)this.getBufferSize());
        }
        catch (ReadOnlyBufferException e) {
            error.enter();
            throw UnsupportedMessageException.create();
        }
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static byte readByte(ByteBuffer byteBuffer, int index) {
        return byteBuffer.get(index);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static short readShort(ByteBuffer byteBuffer, ByteOrder order, int index) {
        return byteBuffer.order(order).asShortBuffer().get(index);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static double readDouble(ByteBuffer byteBuffer, ByteOrder order, int index) {
        return byteBuffer.order(order).asDoubleBuffer().get(index);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static float readFloat(ByteBuffer byteBuffer, ByteOrder order, int index) {
        return byteBuffer.order(order).asFloatBuffer().get(index);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static long readLong(ByteBuffer byteBuffer, ByteOrder order, int index) {
        return byteBuffer.order(order).asLongBuffer().get(index);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static int readInt(ByteBuffer byteBuffer, ByteOrder order, int index) {
        return byteBuffer.order(order).asIntBuffer().get(index);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static void writeByte(ByteBuffer byteBuffer, int index, byte value) {
        byteBuffer.put(index, value);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static void writeShort(ByteBuffer byteBuffer, ByteOrder order, int index, short value) {
        byteBuffer.order(order).asShortBuffer().put(index, value);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static void writeDouble(ByteBuffer byteBuffer, ByteOrder order, int index, double value) {
        byteBuffer.order(order).asDoubleBuffer().put(index, value);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static void writeFloat(ByteBuffer byteBuffer, ByteOrder order, int index, float value) {
        byteBuffer.order(order).asFloatBuffer().put(index, value);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static void writeLong(ByteBuffer byteBuffer, ByteOrder order, int index, long value) {
        byteBuffer.order(order).asLongBuffer().put(index, value);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static void writeInt(ByteBuffer byteBuffer, ByteOrder order, int index, int value) {
        byteBuffer.order(order).asIntBuffer().put(index, value);
    }
}

