/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyAssumption;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyOracle;
import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.CodeAttribute;
import com.oracle.truffle.espresso.classfile.attributes.ExceptionsAttribute;
import com.oracle.truffle.espresso.classfile.attributes.LineNumberTableAttribute;
import com.oracle.truffle.espresso.classfile.attributes.LocalVariableTable;
import com.oracle.truffle.espresso.classfile.attributes.SignatureAttribute;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.ffi.NativeAccess;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.impl.ContextAccess;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.LinkedMethod;
import com.oracle.truffle.espresso.impl.Member;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.ParserKlass;
import com.oracle.truffle.espresso.impl.ParserMethod;
import com.oracle.truffle.espresso.jdwp.api.Ids;
import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.api.MethodHook;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.jni.Mangle;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.ExceptionHandler;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.meta.MetaUtil;
import com.oracle.truffle.espresso.meta.ModifiersProvider;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.nodes.methodhandle.MethodHandleIntrinsicNode;
import com.oracle.truffle.espresso.runtime.Attribute;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.GuestAllocator;
import com.oracle.truffle.espresso.runtime.MethodHandleIntrinsics;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.logging.Level;

public final class Method
extends Member<Symbol.Signature>
implements TruffleObject,
ContextAccess {
    public static final Method[] EMPTY_ARRAY = new Method[0];
    public static final MethodVersion[] EMPTY_VERSION_ARRAY = new MethodVersion[0];
    private static final byte GETTER_LENGTH = 5;
    private static final byte STATIC_GETTER_LENGTH = 4;
    private static final byte SETTER_LENGTH = 6;
    private static final byte STATIC_SETTER_LENGTH = 5;
    private final ObjectKlass declaringKlass;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Symbol<Symbol.Type>[] parsedSignature;
    private final Method proxy;
    private String genericSignature;
    private final Symbol<Symbol.Signature> rawSignature;
    @CompilerDirectives.CompilationFinal
    private volatile MethodVersion methodVersion;
    private boolean removedByRedefinition;
    private final ClassHierarchyAssumption isLeaf;
    private MethodHook[] hooks = MethodHook.EMPTY;
    private final Field.StableBoolean hasActiveHook = new Field.StableBoolean(false);

    Method(Method method) {
        this(method, method.getCodeAttribute());
    }

    private Method(Method method, CodeAttribute split) {
        this.rawSignature = method.rawSignature;
        this.declaringKlass = method.declaringKlass;
        this.methodVersion = new MethodVersion(method.getMethodVersion().klassVersion, method.getRuntimeConstantPool(), method.getLinkedMethod(), method.getMethodVersion().poisonPill, split);
        try {
            this.parsedSignature = this.getSignatures().parsed(this.getRawSignature());
        }
        catch (ClassFormatError | IllegalArgumentException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Meta meta = this.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassFormatError, e.getMessage());
        }
        this.proxy = method.proxy;
        this.isLeaf = method.isLeaf;
    }

    Method(ObjectKlass.KlassVersion klassVersion, LinkedMethod linkedMethod, RuntimeConstantPool pool) {
        this(klassVersion, linkedMethod, linkedMethod.getRawSignature(), pool);
    }

    Method(ObjectKlass.KlassVersion klassVersion, LinkedMethod linkedMethod, Symbol<Symbol.Signature> rawSignature, RuntimeConstantPool pool) {
        this.declaringKlass = klassVersion.getKlass();
        this.rawSignature = rawSignature;
        this.methodVersion = new MethodVersion(klassVersion, pool, linkedMethod, false, (CodeAttribute)linkedMethod.getAttribute(CodeAttribute.NAME));
        try {
            this.parsedSignature = this.getSignatures().parsed(this.getRawSignature());
        }
        catch (ClassFormatError | IllegalArgumentException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Meta meta = this.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassFormatError, e.getMessage());
        }
        this.proxy = this;
        this.isLeaf = this.getContext().getClassHierarchyOracle().createLeafAssumptionForNewMethod(this);
    }

    public Method identity() {
        return this.proxy;
    }

    @Override
    public Symbol<Symbol.Name> getName() {
        return this.getMethodVersion().getName();
    }

    public ConstantPool getConstantPool() {
        return this.getRuntimeConstantPool();
    }

    public RuntimeConstantPool getRuntimeConstantPool() {
        return this.getMethodVersion().pool;
    }

    public LinkedMethod getLinkedMethod() {
        return this.getMethodVersion().linkedMethod;
    }

    public CodeAttribute getCodeAttribute() {
        return this.getMethodVersion().codeAttribute;
    }

    @Override
    @Idempotent
    public ObjectKlass getDeclaringKlass() {
        return this.declaringKlass;
    }

    public Symbol<Symbol.Signature> getRawSignature() {
        if (this.rawSignature != null) {
            return this.rawSignature;
        }
        return this.getLinkedMethod().getRawSignature();
    }

    public Symbol<Symbol.Type>[] getParsedSignature() {
        assert (this.parsedSignature != null);
        return this.parsedSignature;
    }

    public ClassHierarchyAssumption getLeafAssumption(ClassHierarchyOracle.ClassHierarchyAccessor accessor) {
        Objects.requireNonNull(accessor);
        return this.isLeaf;
    }

    public int getRefKind() {
        return this.getMethodVersion().getRefKind();
    }

    public Attribute getAttribute(Symbol<Symbol.Name> attrName) {
        return this.getLinkedMethod().getAttribute(attrName);
    }

    @CompilerDirectives.TruffleBoundary
    public int bciToLineNumber(int atBCI) {
        return this.getMethodVersion().bciToLineNumber(atBCI);
    }

    @Override
    public EspressoContext getContext() {
        return this.declaringKlass.getContext();
    }

    public byte[] getOriginalCode() {
        return this.getCodeAttribute().getOriginalCode();
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.getCodeAttribute().getExceptionHandlers();
    }

    public int[] getSOEHandlerInfo() {
        ArrayList<Integer> toArray = new ArrayList<Integer>();
        for (ExceptionHandler handler : this.getExceptionHandlers()) {
            if (!handler.isCatchAll() && handler.getCatchType() != Symbol.Type.java_lang_StackOverflowError && handler.getCatchType() != Symbol.Type.java_lang_VirtualMachineError && handler.getCatchType() != Symbol.Type.java_lang_Error && handler.getCatchType() != Symbol.Type.java_lang_Throwable) continue;
            toArray.add(handler.getStartBCI());
            toArray.add(handler.getEndBCI());
            toArray.add(handler.getHandlerBCI());
        }
        if (toArray.isEmpty()) {
            return null;
        }
        int[] res = new int[toArray.size()];
        int pos = 0;
        for (Integer i : toArray) {
            res[pos++] = i;
        }
        return res;
    }

    public static NativeSignature buildJniNativeSignature(Symbol<Symbol.Type>[] signature) {
        NativeType returnType = NativeAccess.kindToNativeType(Signatures.returnKind(signature));
        int argCount = Signatures.parameterCount(signature);
        NativeType[] parameterTypes = new NativeType[argCount + 2];
        parameterTypes[0] = NativeType.POINTER;
        parameterTypes[1] = NativeType.OBJECT;
        for (int i = 0; i < argCount; ++i) {
            parameterTypes[i + 2] = NativeAccess.kindToNativeType(Signatures.parameterKind(signature, i));
        }
        return NativeSignature.create(returnType, parameterTypes);
    }

    public TruffleObject lookupAndBind(@Pointer TruffleObject library, String mangledName) {
        NativeSignature signature = Method.buildJniNativeSignature(this.getParsedSignature());
        return this.getNativeAccess().lookupAndBindSymbol(library, mangledName, signature);
    }

    private TruffleObject bind(@Pointer TruffleObject symbol) {
        NativeSignature signature = Method.buildJniNativeSignature(this.getParsedSignature());
        return this.getNativeAccess().bindSymbol(symbol, signature);
    }

    public CallTarget getCallTarget() {
        return this.getMethodVersion().getCallTarget();
    }

    public CallTarget getCallTargetForceInit() {
        this.getDeclaringKlass().safeInitialize();
        return this.getCallTarget();
    }

    public CallTarget getCallTargetNoSubstitution() {
        return this.getMethodVersion().getCallTargetNoSubstitution();
    }

    public boolean usesMonitors() {
        return this.getMethodVersion().usesMonitors();
    }

    private CallTarget lookupLibJavaCallTarget() {
        if (StaticObject.isNull(this.getDeclaringKlass().getDefiningClassLoader())) {
            for (boolean withSignature : new boolean[]{false, true}) {
                String mangledName = Mangle.mangleMethod(this, withSignature);
                TruffleObject nativeMethod = this.lookupAndBind(this.getVM().getJavaLibrary(), mangledName);
                if (nativeMethod == null) continue;
                return EspressoRootNode.createNative(this.getMethodVersion(), nativeMethod).getCallTarget();
            }
        }
        return null;
    }

    private CallTarget lookupAgents() {
        for (boolean withSignature : new boolean[]{false, true}) {
            String mangledName = Mangle.mangleMethod(this, withSignature);
            TruffleObject nativeMethod = this.getContext().bindToAgent(this, mangledName);
            if (nativeMethod == null) continue;
            return EspressoRootNode.createNative(this.getMethodVersion(), nativeMethod).getCallTarget();
        }
        return null;
    }

    private CallTarget lookupJniCallTarget() {
        Method findNative = this.getMeta().java_lang_ClassLoader_findNative;
        CallTarget target = this.lookupJniCallTarget(findNative, false);
        if (target == null) {
            target = this.lookupJniCallTarget(findNative, true);
        }
        return target;
    }

    private CallTarget lookupJniCallTarget(Method findNative, boolean fullSignature) {
        String mangledName = Mangle.mangleMethod(this, fullSignature);
        long handle = (Long)findNative.invokeWithConversions(null, this.getDeclaringKlass().getDefiningClassLoader(), mangledName);
        if (handle == 0L) {
            return null;
        }
        TruffleObject symbol = this.getVM().getFunction(handle);
        TruffleObject nativeMethod = this.bind(symbol);
        return EspressoRootNode.createNative(this.getMethodVersion(), nativeMethod).getCallTarget();
    }

    public boolean isConstructor() {
        return Symbol.Name._init_.equals(this.getName());
    }

    public boolean isDefault() {
        if (this.isConstructor()) {
            return false;
        }
        int mask = 1033;
        return (this.getModifiers() & mask) == 1 && this.getDeclaringKlass().isInterface();
    }

    public boolean canOverride(Method other) {
        if (other.isPrivate() || other.isStatic() || this.isPrivate() || this.isStatic()) {
            return false;
        }
        if (other.isPublic() || other.isProtected()) {
            return true;
        }
        return this.getDeclaringKlass().sameRuntimePackage(other.getDeclaringKlass());
    }

    public ObjectKlass[] getCheckedExceptions() {
        return this.getMethodVersion().getCheckedExceptions();
    }

    public boolean hasBytecodes() {
        return this.isConcrete() && !this.isNative();
    }

    public boolean hasReceiver() {
        return !this.isStatic();
    }

    public boolean isJavaLangObjectInit() {
        return this.getDeclaringKlass().isJavaLangObject() && Symbol.Name._init_.equals(this.getName());
    }

    @CompilerDirectives.TruffleBoundary
    public Object invokeWithConversions(Object self, Object ... args) {
        Object[] filteredArgs;
        this.getContext().getJNI().clearPendingException();
        assert (args.length == Signatures.parameterCount(this.getParsedSignature()));
        if (this.isStatic()) {
            this.getDeclaringKlass().safeInitialize();
            filteredArgs = new Object[args.length];
            for (int i = 0; i < filteredArgs.length; ++i) {
                filteredArgs[i] = this.getMeta().toGuestBoxed(args[i]);
            }
        } else {
            filteredArgs = new Object[args.length + 1];
            filteredArgs[0] = this.getMeta().toGuestBoxed(self);
            for (int i = 1; i < filteredArgs.length; ++i) {
                filteredArgs[i] = this.getMeta().toGuestBoxed(args[i - 1]);
            }
        }
        return this.getMeta().toHostBoxed(this.getCallTarget().call(filteredArgs));
    }

    @CompilerDirectives.TruffleBoundary
    public Object invokeDirect(Object self, Object ... args) {
        this.getContext().getJNI().clearPendingException();
        if (this.isStatic()) {
            assert (args.length == Signatures.parameterCount(this.getParsedSignature()));
            this.getDeclaringKlass().safeInitialize();
            return this.getCallTarget().call(args);
        }
        assert (args.length + 1 == Signatures.parameterCount(this.getParsedSignature()) + (this.isStatic() ? 0 : 1));
        Object[] fullArgs = new Object[args.length + 1];
        System.arraycopy(args, 0, fullArgs, 1, args.length);
        fullArgs[0] = self;
        return this.getCallTarget().call(fullArgs);
    }

    public boolean isClassInitializer() {
        return Symbol.Name._clinit_.equals(this.getName()) && this.isStatic();
    }

    @Override
    public int getModifiers() {
        return this.getMethodVersion().getModifiers();
    }

    public boolean isCallerSensitive() {
        return (this.getModifiers() & 0x80000) != 0;
    }

    public boolean isForceInline() {
        return (this.getModifiers() & 0x20000) != 0 && StaticObject.isNull(this.getDeclaringKlass().getDefiningClassLoader());
    }

    public boolean isHidden() {
        return (this.getModifiers() & 0x100000) != 0;
    }

    public boolean isScoped() {
        return (this.getModifiers() & 0x200000) != 0;
    }

    public int getMethodModifiers() {
        return this.getMethodVersion().getModifiers() & 0x1DFF;
    }

    public String toString() {
        return this.getMethodVersion().toString();
    }

    public JavaKind getReturnKind() {
        return Signatures.returnKind(this.getParsedSignature());
    }

    public Klass[] resolveParameterKlasses() {
        Symbol<Symbol.Type>[] signature = this.getParsedSignature();
        int paramCount = Signatures.parameterCount(signature);
        Klass[] paramsKlasses = paramCount > 0 ? new Klass[paramCount] : Klass.EMPTY_ARRAY;
        for (int i = 0; i < paramCount; ++i) {
            Symbol<Symbol.Type> paramType = Signatures.parameterType(signature, i);
            paramsKlasses[i] = this.getMeta().resolveSymbolOrFail(paramType, this.getDeclaringKlass().getDefiningClassLoader(), this.getDeclaringKlass().protectionDomain());
        }
        return paramsKlasses;
    }

    public Klass resolveReturnKlass() {
        Symbol<Symbol.Type> returnType = Signatures.returnType(this.getParsedSignature());
        return this.getMeta().resolveSymbolOrFail(returnType, this.getDeclaringKlass().getDefiningClassLoader(), this.getDeclaringKlass().protectionDomain());
    }

    @Idempotent
    public int getParameterCount() {
        return Signatures.parameterCount(this.getParsedSignature());
    }

    public int getArgumentCount() {
        return this.getParameterCount() + (this.isStatic() ? 0 : 1);
    }

    public static Method getHostReflectiveMethodRoot(StaticObject seed, Meta meta) {
        assert (seed.getKlass().getMeta().java_lang_reflect_Method.isAssignableFrom(seed.getKlass()));
        StaticObject curMethod = seed;
        while (curMethod != null && StaticObject.notNull(curMethod)) {
            Method target = (Method)meta.HIDDEN_METHOD_KEY.getHiddenObject(curMethod);
            if (target != null) {
                return target;
            }
            curMethod = meta.java_lang_reflect_Method_root.getObject(curMethod);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Could not find HIDDEN_METHOD_KEY");
    }

    public static Method getHostReflectiveConstructorRoot(StaticObject seed, Meta meta) {
        assert (seed.getKlass().getMeta().java_lang_reflect_Constructor.isAssignableFrom(seed.getKlass()));
        StaticObject curMethod = seed;
        while (curMethod != null && StaticObject.notNull(curMethod)) {
            Method target = (Method)meta.HIDDEN_CONSTRUCTOR_KEY.getHiddenObject(curMethod);
            if (target != null) {
                return target;
            }
            curMethod = meta.java_lang_reflect_Constructor_root.getObject(curMethod);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Could not find HIDDEN_CONSTRUCTOR_KEY");
    }

    Method findIntrinsic(Symbol<Symbol.Signature> signature) {
        return this.getContext().getMethodHandleIntrinsics().findIntrinsic(this, signature);
    }

    public boolean isSignaturePolymorphicDeclared() {
        if (!Symbol.Type.java_lang_invoke_MethodHandle.equals(this.getDeclaringKlass().getType()) && !Symbol.Type.java_lang_invoke_VarHandle.equals(this.getDeclaringKlass().getType())) {
            return false;
        }
        Symbol<Symbol.Type>[] signature = this.getParsedSignature();
        if (Signatures.parameterCount(signature) != 1) {
            return false;
        }
        if (Signatures.parameterType(signature, 0) != Symbol.Type.java_lang_Object_array) {
            return false;
        }
        if (this.getJavaVersion().java8OrEarlier() && Signatures.returnType(signature) != Symbol.Type.java_lang_Object) {
            return false;
        }
        int required = 384;
        int flags = this.getModifiers();
        return (flags & required) == required;
    }

    void setVTableIndex(int i) {
        this.getMethodVersion().setVTableIndex(i);
    }

    void setVTableIndex(int i, boolean isRedefinition) {
        this.getMethodVersion().setVTableIndex(i, isRedefinition);
    }

    public int getVTableIndex() {
        return this.getMethodVersion().getVTableIndex();
    }

    void setITableIndex(int i) {
        this.getMethodVersion().setITableIndex(i);
    }

    public int getITableIndex() {
        return this.getMethodVersion().getITableIndex();
    }

    public boolean hasCode() {
        return this.getCodeAttribute() != null || this.isNative();
    }

    public boolean isVirtualCall() {
        return !this.isStatic() && !this.isConstructor() && !this.isPrivate() && !this.getDeclaringKlass().isInterface();
    }

    public void setPoisonPill() {
        this.getMethodVersion().poisonPill = true;
    }

    public boolean hasSourceFileAttribute() {
        return this.declaringKlass.getAttribute(Symbol.Name.SourceFile) != null;
    }

    public String report(int curBCI) {
        String sourceFile = this.getDeclaringKlass().getSourceFile();
        if (sourceFile == null) {
            sourceFile = "unknown source";
        }
        return "at " + MetaUtil.internalNameToJava(this.getDeclaringKlass().getType().toString(), true, false) + "." + this.getName() + "(" + sourceFile + ":" + this.bciToLineNumber(curBCI) + ")";
    }

    public String report() {
        return "at " + MetaUtil.internalNameToJava(this.getDeclaringKlass().getType().toString(), true, false) + "." + this.getName() + "(unknown source)";
    }

    public boolean isInvokeIntrinsic() {
        return this.isNative() && MethodHandleIntrinsics.getId(this) == MethodHandleIntrinsics.PolySigIntrinsics.InvokeGeneric;
    }

    public boolean isPolySignatureIntrinsic() {
        return this.isNative() && MethodHandleIntrinsics.getId(this) != MethodHandleIntrinsics.PolySigIntrinsics.None;
    }

    public boolean isInlinableGetter() {
        if (!(this.getSubstitutions().hasSubstitutionFor(this) || this.getParameterCount() != 0 || this.isAbstract() || this.isNative() || this.isSynchronized())) {
            return this.hasGetterBytecodes();
        }
        return false;
    }

    private boolean hasGetterBytecodes() {
        byte[] code = this.getOriginalCode();
        if (this.isStatic()) {
            if (code.length == 4 && this.getExceptionHandlers().length == 0) {
                return code[0] == -78 && Bytecodes.isReturn(code[3]) && code[3] != -79;
            }
        } else if (code.length == 5 && this.getExceptionHandlers().length == 0) {
            return code[0] == 42 && code[1] == -76 && Bytecodes.isReturn(code[4]) && code[4] != -79;
        }
        return false;
    }

    public boolean isInlinableSetter() {
        if (!(this.getSubstitutions().hasSubstitutionFor(this) || this.getParameterCount() != 1 || this.isAbstract() || this.isNative() || this.isSynchronized())) {
            return this.hasSetterBytecodes();
        }
        return false;
    }

    private boolean hasSetterBytecodes() {
        byte[] code = this.getOriginalCode();
        if (this.isStatic()) {
            if (code.length == 5 && this.getExceptionHandlers().length == 0) {
                return code[0] == 42 && code[1] == -77 && code[4] == -79;
            }
        } else if (code.length == 6 && this.getExceptionHandlers().length == 0) {
            return code[0] == 42 && Bytecodes.isLoad1(code[1]) && code[2] == -75 && code[5] == -79;
        }
        return false;
    }

    public void unregisterNative() {
        assert (this.isNative());
        if (this.getMethodVersion().callTarget != null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getMethodVersion().callTarget = null;
        }
    }

    public void printBytecodes(PrintStream out) {
        new BytecodeStream(this.getOriginalCode()).printBytecode(this.declaringKlass, out);
    }

    public LocalVariableTable getLocalVariableTable() {
        return this.getMethodVersion().getLocalVariableTable();
    }

    public Source getSource() {
        return this.getDeclaringKlass().getSource();
    }

    @CompilerDirectives.TruffleBoundary
    public void checkLoadingConstraints(StaticObject loader1, StaticObject loader2) {
        for (Symbol<Symbol.Type> type : this.getParsedSignature()) {
            this.getContext().getRegistries().checkLoadingConstraint(type, loader1, loader2);
        }
    }

    public int getCatchLocation(int bci, StaticObject ex) {
        ExceptionHandler[] handlers = this.getExceptionHandlers();
        ExceptionHandler resolved = null;
        for (ExceptionHandler toCheck : handlers) {
            if (bci < toCheck.getStartBCI() || bci >= toCheck.getEndBCI()) continue;
            Klass catchType = null;
            if (!toCheck.isCatchAll()) {
                catchType = this.getRuntimeConstantPool().resolvedKlassAt(this.getDeclaringKlass(), toCheck.catchTypeCPI());
            }
            if (catchType != null && !InterpreterToVM.instanceOf(ex, catchType)) continue;
            resolved = toCheck;
            break;
        }
        if (resolved != null) {
            return resolved.getHandlerBCI();
        }
        return -1;
    }

    public Method createIntrinsic(Symbol<Symbol.Signature> polymorphicRawSignature) {
        assert (this.isPolySignatureIntrinsic());
        return new Method(this.declaringKlass.getKlassVersion(), this.getLinkedMethod(), polymorphicRawSignature, this.getRuntimeConstantPool());
    }

    public MethodHandleIntrinsicNode spawnIntrinsicNode(EspressoLanguage language, Meta meta, Klass accessingKlass, Symbol<Symbol.Name> mname, Symbol<Symbol.Signature> signature) {
        assert (this.isPolySignatureIntrinsic());
        return MethodHandleIntrinsics.createIntrinsicNode(language, meta, this, accessingKlass, mname, signature);
    }

    public Method forceSplit() {
        Method result = new Method(this, this.getCodeAttribute());
        EspressoRootNode root = EspressoRootNode.createForBytecodes(result.getMethodVersion());
        result.getMethodVersion().callTarget = root.getCallTarget();
        return result;
    }

    public long getBCIFromLine(int line) {
        return this.getMethodVersion().getBCIFromLine(line);
    }

    public boolean hasLine(int lineNumber) {
        return this.getMethodVersion().hasLine(lineNumber);
    }

    public String getNameAsString() {
        return this.getName().toString();
    }

    @CompilerDirectives.TruffleBoundary
    public String getInteropString() {
        return this.getNameAsString() + "/" + this.getRawSignature();
    }

    public String getSignatureAsString() {
        return this.getRawSignature().toString();
    }

    public KlassRef[] getParameters() {
        return this.resolveParameterKlasses();
    }

    @CompilerDirectives.TruffleBoundary
    public Object invokeMethod(Object callee, Object[] args) {
        if (this.isConstructor()) {
            GuestAllocator.AllocationChecks.checkCanAllocateNewReference(this.getMeta(), this.getDeclaringKlass(), false);
            StaticObject theCallee = this.getAllocator().createNew(this.getDeclaringKlass());
            this.invokeWithConversions(theCallee, args);
            return theCallee;
        }
        return this.invokeWithConversions(callee, args);
    }

    public String getGenericSignatureAsString() {
        if (this.genericSignature == null) {
            SignatureAttribute attr = (SignatureAttribute)this.getLinkedMethod().getAttribute(SignatureAttribute.NAME);
            this.genericSignature = attr == null ? "" : this.getRuntimeConstantPool().symbolAt(attr.getSignatureIndex()).toString();
        }
        return this.genericSignature;
    }

    public boolean hasActiveHook() {
        return this.hasActiveHook.get();
    }

    public synchronized MethodHook[] getMethodHooks() {
        return Arrays.copyOf(this.hooks, this.hooks.length);
    }

    public synchronized void addMethodHook(MethodHook info) {
        this.hasActiveHook.set(true);
        this.hooks = Arrays.copyOf(this.hooks, this.hooks.length + 1);
        this.hooks[this.hooks.length - 1] = info;
    }

    private void expectActiveHooks() {
        if (this.hooks.length == 0) {
            throw new RuntimeException("Method: " + this.getNameAsString() + " expected to contain method hook");
        }
    }

    public synchronized void removeActiveHook(int requestId) {
        this.expectActiveHooks();
        boolean removed = false;
        if (this.hooks.length == 1) {
            if (this.hooks[0].getRequestId() == requestId) {
                this.hooks = MethodHook.EMPTY;
                this.hasActiveHook.set(false);
                removed = true;
            }
        } else {
            int removeIndex = -1;
            for (int i = 0; i < this.hooks.length; ++i) {
                if (this.hooks[i].getRequestId() != requestId) continue;
                removeIndex = i;
                break;
            }
            if (removeIndex != -1) {
                MethodHook[] temp = new MethodHook[this.hooks.length - 1];
                for (int i = 0; i < temp.length; ++i) {
                    temp[i] = i < removeIndex ? this.hooks[i] : this.hooks[i + 1];
                }
                this.hooks = temp;
                removed = true;
            }
        }
        if (!removed) {
            throw new RuntimeException("Method: " + this.getNameAsString() + " should contain method hook");
        }
    }

    public synchronized void removeActiveHook(MethodHook hook) {
        this.expectActiveHooks();
        boolean removed = false;
        if (this.hooks.length == 1) {
            if (this.hooks[0] == hook) {
                this.hooks = MethodHook.EMPTY;
                this.hasActiveHook.set(false);
                removed = true;
            }
        } else {
            int removeIndex = -1;
            for (int i = 0; i < this.hooks.length; ++i) {
                if (this.hooks[i] != hook) continue;
                removeIndex = i;
                break;
            }
            if (removeIndex != -1) {
                MethodHook[] temp = new MethodHook[this.hooks.length - 1];
                for (int i = 0; i < temp.length; ++i) {
                    temp[i] = i < removeIndex ? this.hooks[i] : this.hooks[i + 1];
                }
                this.hooks = temp;
                removed = true;
            }
        }
        if (!removed) {
            throw new RuntimeException("Method: " + this.getNameAsString() + " should contain method hook");
        }
    }

    public SharedRedefinitionContent redefine(ObjectKlass.KlassVersion klassVersion, ParserMethod newMethod, ParserKlass newKlass, Ids<Object> ids) {
        LinkedMethod newLinkedMethod = new LinkedMethod(newMethod);
        RuntimeConstantPool runtimePool = new RuntimeConstantPool(this.getContext(), newKlass.getConstantPool(), this.getDeclaringKlass().getDefiningClassLoader());
        CodeAttribute newCodeAttribute = (CodeAttribute)newMethod.getAttribute(Symbol.Name.Code);
        MethodVersion oldVersion = this.methodVersion;
        this.methodVersion = oldVersion.replace(klassVersion, runtimePool, newLinkedMethod, newCodeAttribute);
        ids.replaceObject(oldVersion, this.methodVersion);
        return new SharedRedefinitionContent(this.methodVersion, newLinkedMethod, runtimePool, newCodeAttribute);
    }

    public void redefine(ObjectKlass.KlassVersion klassVersion, SharedRedefinitionContent content, Ids<Object> ids) {
        MethodVersion oldVersion = this.methodVersion;
        this.methodVersion = oldVersion.replace(klassVersion, content.getPool(), content.getLinkedMethod(), content.codeAttribute);
        ids.replaceObject(oldVersion, this.methodVersion);
    }

    public MethodVersion swapMethodVersion(ObjectKlass.KlassVersion klassVersion, Ids<Object> ids) {
        MethodVersion oldVersion = this.methodVersion;
        CodeAttribute codeAttribute = oldVersion.getCodeAttribute();
        CodeAttribute newCodeAttribute = codeAttribute != null ? new CodeAttribute(codeAttribute) : null;
        this.methodVersion = oldVersion.replace(klassVersion, oldVersion.pool, oldVersion.linkedMethod, newCodeAttribute);
        ids.replaceObject(oldVersion, this.methodVersion);
        return this.methodVersion;
    }

    public MethodVersion getMethodVersion() {
        MethodVersion version = this.methodVersion;
        if (!version.getRedefineAssumption().isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getContext().getClassRedefinition().check();
            if (this.isRemovedByRedefinition()) {
                return version;
            }
            while (!(version = this.methodVersion).getRedefineAssumption().isValid()) {
            }
        }
        return version;
    }

    public void removedByRedefinition() {
        this.removedByRedefinition = true;
    }

    public boolean isRemovedByRedefinition() {
        return this.removedByRedefinition;
    }

    public StaticObject makeMirror(Meta meta) {
        Attribute rawRuntimeVisibleAnnotations = this.getAttribute(Symbol.Name.RuntimeVisibleAnnotations);
        StaticObject runtimeVisibleAnnotations = rawRuntimeVisibleAnnotations != null ? StaticObject.wrap(rawRuntimeVisibleAnnotations.getData(), meta) : StaticObject.NULL;
        Attribute rawRuntimeVisibleParameterAnnotations = this.getAttribute(Symbol.Name.RuntimeVisibleParameterAnnotations);
        StaticObject runtimeVisibleParameterAnnotations = rawRuntimeVisibleParameterAnnotations != null ? StaticObject.wrap(rawRuntimeVisibleParameterAnnotations.getData(), meta) : StaticObject.NULL;
        Attribute rawRuntimeVisibleTypeAnnotations = this.getAttribute(Symbol.Name.RuntimeVisibleTypeAnnotations);
        StaticObject runtimeVisibleTypeAnnotations = rawRuntimeVisibleTypeAnnotations != null ? StaticObject.wrap(rawRuntimeVisibleTypeAnnotations.getData(), meta) : StaticObject.NULL;
        Attribute rawAnnotationDefault = this.getAttribute(Symbol.Name.AnnotationDefault);
        StaticObject annotationDefault = rawAnnotationDefault != null ? StaticObject.wrap(rawAnnotationDefault.getData(), meta) : StaticObject.NULL;
        final Klass[] rawParameterKlasses = this.resolveParameterKlasses();
        StaticObject parameterTypes = meta.java_lang_Class.allocateReferenceArray(this.getParameterCount(), new IntFunction<StaticObject>(){

            @Override
            public StaticObject apply(int j) {
                return rawParameterKlasses[j].mirror();
            }
        });
        final Klass[] rawCheckedExceptions = this.getCheckedExceptions();
        StaticObject guestCheckedExceptions = meta.java_lang_Class.allocateReferenceArray(rawCheckedExceptions.length, new IntFunction<StaticObject>(){

            @Override
            public StaticObject apply(int j) {
                return rawCheckedExceptions[j].mirror();
            }
        });
        SignatureAttribute signatureAttribute = (SignatureAttribute)this.getAttribute(Symbol.Name.Signature);
        StaticObject guestGenericSignature = StaticObject.NULL;
        if (signatureAttribute != null) {
            String sig = this.getConstantPool().symbolAt(signatureAttribute.getSignatureIndex(), "signature").toString();
            guestGenericSignature = meta.toGuestString(sig);
        }
        StaticObject instance = meta.java_lang_reflect_Method.allocateInstance(meta.getContext());
        meta.java_lang_reflect_Method_init.invokeDirect(instance, this.getDeclaringKlass().mirror(), this.getContext().getStrings().intern(this.getName()), parameterTypes, this.resolveReturnKlass().mirror(), guestCheckedExceptions, this.getMethodModifiers(), this.getVTableIndex(), guestGenericSignature, runtimeVisibleAnnotations, runtimeVisibleParameterAnnotations, annotationDefault);
        meta.HIDDEN_METHOD_KEY.setHiddenObject(instance, this);
        meta.HIDDEN_METHOD_RUNTIME_VISIBLE_TYPE_ANNOTATIONS.setHiddenObject(instance, runtimeVisibleTypeAnnotations);
        return instance;
    }

    public final class MethodVersion
    implements MethodRef,
    ModifiersProvider {
        private final ObjectKlass.KlassVersion klassVersion;
        private final RuntimeConstantPool pool;
        private final LinkedMethod linkedMethod;
        private final CodeAttribute codeAttribute;
        private final ExceptionsAttribute exceptionsAttribute;
        @CompilerDirectives.CompilationFinal
        private CallTarget callTarget;
        @CompilerDirectives.CompilationFinal
        private int vtableIndex = -1;
        @CompilerDirectives.CompilationFinal
        private int itableIndex = -1;
        @CompilerDirectives.CompilationFinal
        private byte usesMonitors = (byte)-1;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private volatile byte[] code = null;
        @CompilerDirectives.CompilationFinal
        private int refKind;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private ObjectKlass[] checkedExceptions;
        @CompilerDirectives.CompilationFinal
        private boolean poisonPill;

        private MethodVersion(ObjectKlass.KlassVersion klassVersion, RuntimeConstantPool pool, LinkedMethod linkedMethod, boolean poisonPill, CodeAttribute codeAttribute) {
            this.klassVersion = klassVersion;
            this.pool = pool;
            this.linkedMethod = linkedMethod;
            this.codeAttribute = codeAttribute;
            this.exceptionsAttribute = (ExceptionsAttribute)linkedMethod.getAttribute(ExceptionsAttribute.NAME);
            this.poisonPill = poisonPill;
            this.initRefKind();
        }

        public SourceSection getWholeMethodSourceSection() {
            Source s = this.getSource();
            if (s == null) {
                return null;
            }
            LineNumberTableAttribute lineNumberTable = this.getLineNumberTableAttribute();
            if (lineNumberTable != LineNumberTableAttribute.EMPTY) {
                List<LineNumberTableAttribute.Entry> entries = lineNumberTable.getEntries();
                int startLine = Integer.MAX_VALUE;
                int endLine = 0;
                for (int i = 0; i < entries.size(); ++i) {
                    int line = entries.get(i).getLineNumber();
                    if (line > endLine) {
                        endLine = line;
                    }
                    if (line >= startLine) continue;
                    startLine = line;
                }
                if (startLine >= 1 && endLine >= 1 && startLine <= endLine) {
                    return s.createSection(startLine, -1, endLine, -1);
                }
            }
            return s.createUnavailableSection();
        }

        public void initRefKind() {
            if (Modifier.isStatic(this.linkedMethod.getFlags())) {
                this.refKind = 6;
            } else if (Modifier.isPrivate(this.linkedMethod.getFlags()) || Symbol.Name._init_.equals(this.linkedMethod.getName())) {
                this.refKind = 7;
            } else if (this.klassVersion.isInterface()) {
                this.refKind = 9;
            } else {
                assert (!Method.this.declaringKlass.isPrimitive());
                this.refKind = 5;
            }
        }

        public MethodVersion replace(ObjectKlass.KlassVersion version, RuntimeConstantPool constantPool, LinkedMethod newLinkedMethod, CodeAttribute newCodeAttribute) {
            MethodVersion result = new MethodVersion(version, constantPool, newLinkedMethod, false, newCodeAttribute);
            result.vtableIndex = this.vtableIndex;
            result.itableIndex = this.itableIndex;
            return result;
        }

        public LinkedMethod getLinkedMethod() {
            return this.linkedMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getCode() {
            if (this.code == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                MethodVersion methodVersion = this;
                synchronized (methodVersion) {
                    if (this.code == null) {
                        byte[] originalCode = this.getCodeAttribute().getOriginalCode();
                        this.code = Arrays.copyOf(originalCode, originalCode.length);
                    }
                }
            }
            return this.code;
        }

        @Idempotent
        public Method getMethod() {
            return Method.this;
        }

        public Symbol<Symbol.Name> getName() {
            return this.linkedMethod.getName();
        }

        public Symbol<Symbol.Signature> getRawSignature() {
            return this.getMethod().getRawSignature();
        }

        public Assumption getRedefineAssumption() {
            return this.klassVersion.getAssumption();
        }

        public CodeAttribute getCodeAttribute() {
            return this.codeAttribute;
        }

        void setVTableIndex(int i) {
            this.setVTableIndex(i, false);
        }

        void setVTableIndex(int i, boolean isRedefinition) {
            assert (this.vtableIndex == -1 || this.vtableIndex == i || isRedefinition);
            assert (this.itableIndex == -1);
            CompilerAsserts.neverPartOfCompilation();
            this.vtableIndex = i;
        }

        public int getVTableIndex() {
            return this.vtableIndex;
        }

        void setITableIndex(int i) {
            assert (this.itableIndex == -1 || this.itableIndex == i);
            assert (this.vtableIndex == -1);
            CompilerAsserts.neverPartOfCompilation();
            this.itableIndex = i;
        }

        public int getITableIndex() {
            return this.itableIndex;
        }

        public ExceptionHandler[] getExceptionHandlers() {
            return this.codeAttribute.getExceptionHandlers();
        }

        public RuntimeConstantPool getPool() {
            return this.pool;
        }

        private CallTarget getCallTargetNoSubstitution() {
            CompilerAsserts.neverPartOfCompilation();
            EspressoError.guarantee(Method.this.getSubstitutions().hasSubstitutionFor(this.getMethod()), "Using 'getCallTargetNoSubstitution' should be done only to bypass the substitution mechanism.");
            return this.findCallTarget();
        }

        public CallTarget getCallTarget() {
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (this.callTarget == null ? 1 : 0) != 0)) {
                if (CompilerDirectives.isCompilationConstant((Object)this)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                this.resolveCallTarget();
            }
            return this.callTarget;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void resolveCallTarget() {
            Meta meta = Method.this.getMeta();
            this.checkPoisonPill(meta);
            MethodVersion methodVersion = this;
            synchronized (methodVersion) {
                if (this.callTarget != null) {
                    return;
                }
                if (Method.this.proxy != Method.this) {
                    this.callTarget = Method.this.proxy.getCallTarget();
                    return;
                }
                EspressoRootNode redirectedMethod = Method.this.getSubstitutions().get(this.getMethod());
                if (redirectedMethod != null) {
                    this.callTarget = redirectedMethod.getCallTarget();
                    return;
                }
                CallTarget target = this.findCallTarget();
                if (target != null) {
                    this.callTarget = target;
                    return;
                }
            }
        }

        private CallTarget findCallTarget() {
            CallTarget target;
            if (this.isNative()) {
                target = Method.this.lookupLibJavaCallTarget();
                if (target == null) {
                    target = Method.this.lookupAgents();
                }
                if (target == null) {
                    target = Method.this.lookupJniCallTarget();
                }
                if (target == null && Method.this.isSignaturePolymorphicDeclared()) {
                    target = Method.this.declaringKlass.lookupPolysigMethod(this.getName(), this.getRawSignature(), Klass.LookupMode.ALL).getCallTarget();
                }
                if (target == null) {
                    Method.this.getContext().getLogger().log(Level.WARNING, "Failed to link native method: {0}", (Object)this.toString());
                    Meta meta = Method.this.getMeta();
                    throw meta.throwException(meta.java_lang_UnsatisfiedLinkError);
                }
            } else {
                if (this.codeAttribute == null) {
                    Meta meta = Method.this.getMeta();
                    throw meta.throwExceptionWithMessage(meta.java_lang_AbstractMethodError, "Calling abstract method: " + this.getMethod().getDeclaringKlass().getType() + "." + this.getName() + " -> " + this.getRawSignature());
                }
                EspressoRootNode rootNode = EspressoRootNode.createForBytecodes(this);
                target = rootNode.getCallTarget();
            }
            return target;
        }

        private void checkPoisonPill(Meta meta) {
            if (this.poisonPill) {
                if (Method.this.getJavaVersion().java9OrLater() && Method.this.getSpecComplianceMode() == EspressoOptions.SpecComplianceMode.HOTSPOT) {
                    throw meta.throwExceptionWithMessage(meta.java_lang_AbstractMethodError, "Conflicting default methods: " + this.getName());
                }
                throw meta.throwExceptionWithMessage(meta.java_lang_IncompatibleClassChangeError, "Conflicting default methods: " + this.getName());
            }
        }

        public int getCodeSize() {
            return this.getCode() != null ? this.getCode().length : 0;
        }

        public LineNumberTableAttribute getLineNumberTableAttribute() {
            if (this.codeAttribute != null) {
                LineNumberTableAttribute lineNumberTable = this.codeAttribute.getLineNumberTableAttribute();
                return lineNumberTable != null ? lineNumberTable : LineNumberTableAttribute.EMPTY;
            }
            return LineNumberTableAttribute.EMPTY;
        }

        @Override
        public long getBCIFromLine(int line) {
            return this.getLineNumberTable().getBCI(line);
        }

        @Override
        public Source getSource() {
            return this.getMethod().getSource();
        }

        @Override
        public boolean hasLine(int lineNumber) {
            return this.getLineNumberTable().getBCI(lineNumber) != -1L;
        }

        @Override
        public String getSourceFile() {
            return this.getDeclaringKlass().getSourceFile();
        }

        @Override
        public String getNameAsString() {
            return this.getName().toString();
        }

        @Override
        public String getSignatureAsString() {
            return this.getMethod().getSignatureAsString();
        }

        @Override
        public String getGenericSignatureAsString() {
            return this.getMethod().getGenericSignatureAsString();
        }

        @Override
        public int getModifiers() {
            return this.linkedMethod.getFlags();
        }

        @Override
        public int bciToLineNumber(int bci) {
            if (bci < 0) {
                return bci;
            }
            return this.getCodeAttribute().bciToLineNumber(bci);
        }

        @Override
        public boolean isMethodNative() {
            return this.isNative();
        }

        @Override
        public byte[] getOriginalCode() {
            return this.getCodeAttribute().getOriginalCode();
        }

        @Override
        public KlassRef[] getParameters() {
            return this.getMethod().getParameters();
        }

        @Override
        public LocalVariableTable getLocalVariableTable() {
            if (this.codeAttribute != null) {
                return this.codeAttribute.getLocalvariableTable();
            }
            return LocalVariableTable.EMPTY_LVT;
        }

        @Override
        public LocalVariableTable getLocalVariableTypeTable() {
            if (this.codeAttribute != null) {
                return this.codeAttribute.getLocalvariableTypeTable();
            }
            return LocalVariableTable.EMPTY_LVTT;
        }

        @Override
        public boolean hasVariableTable() {
            return this.getLocalVariableTable() != LocalVariableTable.EMPTY_LVT;
        }

        @Override
        public LineNumberTableAttribute getLineNumberTable() {
            return this.getLineNumberTableAttribute();
        }

        @Override
        public Object invokeMethod(Object callee, Object[] args) {
            if (this.getMethod().isRemovedByRedefinition()) {
                Meta meta = Method.this.getMeta();
                throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchMethodError, meta.toGuestString(this.getMethod().getDeclaringKlass().getNameAsString() + "." + this.getName() + this.getRawSignature()));
            }
            return this.getMethod().invokeMethod(callee, args);
        }

        @Override
        public boolean hasSourceFileAttribute() {
            return this.getMethod().hasSourceFileAttribute();
        }

        @Override
        public boolean isLastLine(long codeIndex) {
            int lineAt;
            LineNumberTableAttribute table = this.getLineNumberTable();
            int lastLine = table.getLastLine();
            return lastLine == (lineAt = table.getLineNumber((int)codeIndex));
        }

        @Override
        public KlassRef getDeclaringKlassRef() {
            return this.getMethod().getDeclaringKlass();
        }

        @Override
        public int getFirstLine() {
            return this.getLineNumberTable().getFirstLine();
        }

        @Override
        public int getLastLine() {
            return this.getLineNumberTable().getLastLine();
        }

        @Override
        public MethodHook[] getMethodHooks() {
            return this.getMethod().getMethodHooks();
        }

        @Override
        public void addMethodHook(MethodHook info) {
            this.getMethod().addMethodHook(info);
        }

        @Override
        public void removedMethodHook(int requestId) {
            this.getMethod().removeActiveHook(requestId);
        }

        @Override
        public void removedMethodHook(MethodHook hook) {
            this.getMethod().removeActiveHook(hook);
        }

        @Override
        public boolean hasActiveHook() {
            return this.getMethod().hasActiveHook();
        }

        @Override
        public boolean isObsolete() {
            return !this.klassVersion.getAssumption().isValid();
        }

        @Override
        public long getLastBCI() {
            int bci = 0;
            BytecodeStream bs = new BytecodeStream(this.getCode());
            int end = bs.endBCI();
            while (bci < end) {
                int nextBCI = bs.nextBCI(bci);
                if (nextBCI >= end || nextBCI == bci) {
                    return bci;
                }
                bci = nextBCI;
            }
            return bci;
        }

        public String toString() {
            return "EspressoMethod<" + this.getDeclaringKlass().getType() + "." + this.getName() + this.getRawSignature() + ">";
        }

        public boolean usesMonitors() {
            if (this.usesMonitors != -1) {
                return this.usesMonitors != 0;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (this.isSynchronized()) {
                this.usesMonitors = 1;
                return 1 != 0;
            }
            if (this.codeAttribute != null) {
                BytecodeStream bs = new BytecodeStream(this.codeAttribute.getOriginalCode());
                int bci = 0;
                while (bci < bs.endBCI()) {
                    int opcode = bs.currentBC(bci);
                    if (opcode == 194 || opcode == 195) {
                        this.usesMonitors = 1;
                        return 1 != 0;
                    }
                    bci = bs.nextBCI(bci);
                }
                this.usesMonitors = 0;
                return 0 != 0;
            }
            return false;
        }

        public int getRefKind() {
            return this.refKind;
        }

        public ObjectKlass[] getCheckedExceptions() {
            if (this.checkedExceptions == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.createCheckedExceptions();
            }
            return this.checkedExceptions;
        }

        private synchronized void createCheckedExceptions() {
            if (this.checkedExceptions == null) {
                if (this.exceptionsAttribute == null) {
                    this.checkedExceptions = ObjectKlass.EMPTY_ARRAY;
                    return;
                }
                int[] entries = this.exceptionsAttribute.getCheckedExceptionsCPI();
                ObjectKlass[] tmpchecked = new ObjectKlass[entries.length];
                for (int i = 0; i < entries.length; ++i) {
                    tmpchecked[i] = (ObjectKlass)this.pool.resolvedKlassAt(Method.this.declaringKlass, entries[i]);
                }
                this.checkedExceptions = tmpchecked;
            }
        }

        public ObjectKlass.KlassVersion getKlassVersion() {
            return this.klassVersion;
        }

        public ObjectKlass getDeclaringKlass() {
            return Method.this.declaringKlass;
        }

        public void checkLoadingConstraints(StaticObject loader1, StaticObject loader2) {
            this.getMethod().checkLoadingConstraints(loader1, loader2);
        }

        public int getMaxLocals() {
            return this.codeAttribute.getMaxLocals();
        }

        public int getMaxStackSize() {
            return this.codeAttribute.getMaxStack();
        }
    }

    static class SharedRedefinitionContent {
        private final MethodVersion version;
        private final LinkedMethod linkedMethod;
        private final RuntimeConstantPool pool;
        private final CodeAttribute codeAttribute;

        SharedRedefinitionContent(MethodVersion version, LinkedMethod linkedMethod, RuntimeConstantPool pool, CodeAttribute codeAttribute) {
            this.version = version;
            this.linkedMethod = linkedMethod;
            this.pool = pool;
            this.codeAttribute = codeAttribute;
        }

        public MethodVersion getMethodVersion() {
            return this.version;
        }

        public LinkedMethod getLinkedMethod() {
            return this.linkedMethod;
        }

        public RuntimeConstantPool getPool() {
            return this.pool;
        }

        public CodeAttribute getCodeAttribute() {
            return this.codeAttribute;
        }
    }
}

