/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.staticobject.StaticProperty;
import com.oracle.truffle.api.staticobject.StaticShape;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.LinkedField;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.runtime.staticobject.ExtensionFieldObjectFactory;
import com.oracle.truffle.espresso.runtime.staticobject.FieldStorageObject;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.WeakHashMap;

public class RedefineAddedField
extends Field {
    private Field compatibleField;
    private StaticShape<ExtensionFieldObjectFactory> extensionShape;
    private final FieldStorageObject staticStorageObject;
    private final WeakHashMap<StaticObject, FieldStorageObject> storageObjects = new WeakHashMap(1);

    public RedefineAddedField(ObjectKlass.KlassVersion holder, LinkedField linkedField, RuntimeConstantPool pool, boolean isDelegation) {
        super(holder, linkedField, pool);
        if (!isDelegation) {
            StaticShape.Builder shapeBuilder = StaticShape.newBuilder((TruffleLanguage)holder.getKlass().getLanguage());
            shapeBuilder.property((StaticProperty)linkedField, linkedField.getParserField().getPropertyType(), linkedField.getParserField().isFinal());
            this.extensionShape = shapeBuilder.build(FieldStorageObject.class, ExtensionFieldObjectFactory.class);
        }
        if (linkedField.getParserField().isStatic() && !isDelegation) {
            this.staticStorageObject = ((ExtensionFieldObjectFactory)this.extensionShape.getFactory()).create();
            if (linkedField.getKind().isObject()) {
                linkedField.setObject(this.staticStorageObject, StaticObject.NULL);
            }
        } else {
            this.staticStorageObject = null;
        }
    }

    public static Field createDelegationField(Field field) {
        RedefineAddedField delegationField = new RedefineAddedField(field.getDeclaringKlass().getKlassVersion(), field.linkedField, field.pool, true);
        delegationField.setCompatibleField(field);
        return delegationField;
    }

    @Override
    public void setCompatibleField(Field field) {
        this.compatibleField = field;
    }

    @Override
    public boolean hasCompatibleField() {
        return this.compatibleField != null;
    }

    @Override
    public Field getCompatibleField() {
        return this.compatibleField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private FieldStorageObject getStorageObject(StaticObject instance) {
        if (this.isStatic()) {
            return this.staticStorageObject;
        }
        FieldStorageObject storageObject = this.storageObjects.get(instance);
        if (storageObject == null) {
            WeakHashMap<StaticObject, FieldStorageObject> weakHashMap = this.storageObjects;
            synchronized (weakHashMap) {
                storageObject = this.storageObjects.get(instance);
                if (storageObject == null) {
                    storageObject = ((ExtensionFieldObjectFactory)this.extensionShape.getFactory()).create();
                    if (this.getKind().isObject()) {
                        this.linkedField.setObject(storageObject, StaticObject.NULL);
                    }
                    if (this.getDeclaringKlass() != instance.getKlass()) {
                        this.checkPullUpField(instance, storageObject);
                    }
                    this.storageObjects.put(instance, storageObject);
                }
            }
        }
        return storageObject;
    }

    private void checkPullUpField(StaticObject instance, FieldStorageObject storageObject) {
        if (instance.getKlass() instanceof ObjectKlass) {
            for (ObjectKlass current = (ObjectKlass)instance.getKlass(); current != this.getDeclaringKlass(); current = current.getSuperKlass()) {
                Field removedField = current.getRemovedField(this);
                if (removedField == null) continue;
                switch (this.getKind()) {
                    case Boolean: {
                        this.linkedField.setBoolean(storageObject, removedField.linkedField.getBooleanVolatile(instance));
                        return;
                    }
                    case Byte: {
                        this.linkedField.setByte(storageObject, removedField.linkedField.getByteVolatile(instance));
                        return;
                    }
                    case Short: {
                        this.linkedField.setShort(storageObject, removedField.linkedField.getShortVolatile(instance));
                        return;
                    }
                    case Char: {
                        this.linkedField.setChar(storageObject, removedField.linkedField.getCharVolatile(instance));
                        return;
                    }
                    case Int: {
                        this.linkedField.setInt(storageObject, removedField.linkedField.getIntVolatile(instance));
                        return;
                    }
                    case Float: {
                        this.linkedField.setFloat(storageObject, removedField.linkedField.getFloatVolatile(instance));
                        return;
                    }
                    case Long: {
                        this.linkedField.setLong(storageObject, removedField.linkedField.getLongVolatile(instance));
                        return;
                    }
                    case Double: {
                        this.linkedField.setDouble(storageObject, removedField.linkedField.getDoubleVolatile(instance));
                        return;
                    }
                    case Object: {
                        this.linkedField.setObject(storageObject, removedField.linkedField.getObjectVolatile(instance));
                        return;
                    }
                }
            }
        }
    }

    @Override
    public StaticObject getObject(StaticObject obj, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().getObject(obj, forceVolatile);
        }
        FieldStorageObject storageObject = this.getStorageObject(obj);
        StaticObject result = forceVolatile ? (StaticObject)this.linkedField.getObjectVolatile(storageObject) : (StaticObject)this.linkedField.getObject(storageObject);
        if (result == StaticObject.NULL) {
            return result;
        }
        if (this.getDeclaringKlass().getContext().anyHierarchyChanged()) {
            return this.checkGetValueValidity(result);
        }
        return result;
    }

    @Override
    public void setObject(StaticObject obj, Object value, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            this.getCompatibleField().setObject(obj, value, forceVolatile);
        } else {
            if (this.getDeclaringKlass().getContext().anyHierarchyChanged()) {
                this.checkSetValueValifity(value);
            }
            FieldStorageObject storageObject = this.getStorageObject(obj);
            if (forceVolatile) {
                this.linkedField.setObjectVolatile(storageObject, value);
            } else {
                this.linkedField.setObject(storageObject, value);
            }
        }
    }

    @Override
    public StaticObject getAndSetObject(StaticObject obj, StaticObject value) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().getAndSetObject(obj, value);
        }
        return (StaticObject)this.linkedField.getAndSetObject(this.getStorageObject(obj), value);
    }

    @Override
    public boolean compareAndSwapObject(StaticObject obj, Object before, Object after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndSwapObject(obj, before, after);
        }
        return this.linkedField.compareAndSwapObject(this.getStorageObject(obj), before, after);
    }

    @Override
    public StaticObject compareAndExchangeObject(StaticObject obj, Object before, Object after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndExchangeObject(obj, before, after);
        }
        return (StaticObject)this.linkedField.compareAndExchangeObject(this.getStorageObject(obj), before, after);
    }

    @Override
    public boolean getBoolean(StaticObject obj, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().getBoolean(obj, forceVolatile);
        }
        FieldStorageObject storageObject = this.getStorageObject(obj);
        if (forceVolatile) {
            return this.linkedField.getBooleanVolatile(storageObject);
        }
        return this.linkedField.getBoolean(storageObject);
    }

    @Override
    public void setBoolean(StaticObject obj, boolean value, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            this.getCompatibleField().setBoolean(obj, value, forceVolatile);
        } else {
            FieldStorageObject storageObject = this.getStorageObject(obj);
            if (forceVolatile) {
                this.linkedField.setBooleanVolatile(storageObject, value);
            } else {
                this.linkedField.setBoolean(storageObject, value);
            }
        }
    }

    @Override
    public boolean compareAndSwapBoolean(StaticObject obj, boolean before, boolean after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndSwapBoolean(obj, before, after);
        }
        return this.linkedField.compareAndSwapBoolean(this.getStorageObject(obj), before, after);
    }

    @Override
    public boolean compareAndExchangeBoolean(StaticObject obj, boolean before, boolean after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndExchangeBoolean(obj, before, after);
        }
        return this.linkedField.compareAndExchangeBoolean(this.getStorageObject(obj), before, after);
    }

    @Override
    public byte getByte(StaticObject obj, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().getByte(obj, forceVolatile);
        }
        FieldStorageObject storageObject = this.getStorageObject(obj);
        if (forceVolatile) {
            return this.linkedField.getByteVolatile(storageObject);
        }
        return this.linkedField.getByte(storageObject);
    }

    @Override
    public void setByte(StaticObject obj, byte value, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            this.getCompatibleField().setByte(obj, value, forceVolatile);
        } else {
            FieldStorageObject storageObject = this.getStorageObject(obj);
            if (forceVolatile) {
                this.linkedField.setByteVolatile(storageObject, value);
            } else {
                this.linkedField.setByte(storageObject, value);
            }
        }
    }

    @Override
    public boolean compareAndSwapByte(StaticObject obj, byte before, byte after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndSwapByte(obj, before, after);
        }
        return this.linkedField.compareAndSwapByte(this.getStorageObject(obj), before, after);
    }

    @Override
    public byte compareAndExchangeByte(StaticObject obj, byte before, byte after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndExchangeByte(obj, before, after);
        }
        return this.linkedField.compareAndExchangeByte(this.getStorageObject(obj), before, after);
    }

    @Override
    public char getChar(StaticObject obj, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().getChar(obj, forceVolatile);
        }
        FieldStorageObject storageObject = this.getStorageObject(obj);
        if (forceVolatile) {
            return this.linkedField.getCharVolatile(storageObject);
        }
        return this.linkedField.getChar(storageObject);
    }

    @Override
    public void setChar(StaticObject obj, char value, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            this.getCompatibleField().setChar(obj, value, forceVolatile);
        } else {
            FieldStorageObject storageObject = this.getStorageObject(obj);
            if (forceVolatile) {
                this.linkedField.setCharVolatile(storageObject, value);
            } else {
                this.linkedField.setChar(storageObject, value);
            }
        }
    }

    @Override
    public boolean compareAndSwapChar(StaticObject obj, char before, char after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndSwapChar(obj, before, after);
        }
        return this.linkedField.compareAndSwapChar(this.getStorageObject(obj), before, after);
    }

    @Override
    public char compareAndExchangeChar(StaticObject obj, char before, char after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndExchangeChar(obj, before, after);
        }
        return this.linkedField.compareAndExchangeChar(this.getStorageObject(obj), before, after);
    }

    @Override
    public double getDouble(StaticObject obj, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().getDouble(obj, forceVolatile);
        }
        FieldStorageObject storageObject = this.getStorageObject(obj);
        if (forceVolatile) {
            return this.linkedField.getDoubleVolatile(storageObject);
        }
        return this.linkedField.getDouble(storageObject);
    }

    @Override
    public void setDouble(StaticObject obj, double value, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            this.getCompatibleField().setDouble(obj, value, forceVolatile);
        } else {
            FieldStorageObject storageObject = this.getStorageObject(obj);
            if (forceVolatile) {
                this.linkedField.setDoubleVolatile(storageObject, value);
            } else {
                this.linkedField.setDouble(storageObject, value);
            }
        }
    }

    @Override
    public boolean compareAndSwapDouble(StaticObject obj, double before, double after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndSwapDouble(obj, before, after);
        }
        return this.linkedField.compareAndSwapDouble(this.getStorageObject(obj), before, after);
    }

    @Override
    public double compareAndExchangeDouble(StaticObject obj, double before, double after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndExchangeDouble(obj, before, after);
        }
        return this.linkedField.compareAndExchangeDouble(this.getStorageObject(obj), before, after);
    }

    @Override
    public float getFloat(StaticObject obj, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().getFloat(obj, forceVolatile);
        }
        FieldStorageObject storageObject = this.getStorageObject(obj);
        if (forceVolatile) {
            return this.linkedField.getFloatVolatile(storageObject);
        }
        return this.linkedField.getFloat(storageObject);
    }

    @Override
    public void setFloat(StaticObject obj, float value, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            this.getCompatibleField().setFloat(obj, value, forceVolatile);
        } else {
            FieldStorageObject storageObject = this.getStorageObject(obj);
            if (forceVolatile) {
                this.linkedField.setFloatVolatile(storageObject, value);
            } else {
                this.linkedField.setFloat(storageObject, value);
            }
        }
    }

    @Override
    public boolean compareAndSwapFloat(StaticObject obj, float before, float after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndSwapFloat(obj, before, after);
        }
        return this.linkedField.compareAndSwapFloat(this.getStorageObject(obj), before, after);
    }

    @Override
    public float compareAndExchangeFloat(StaticObject obj, float before, float after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndExchangeFloat(obj, before, after);
        }
        return this.linkedField.compareAndExchangeFloat(this.getStorageObject(obj), before, after);
    }

    @Override
    public int getInt(StaticObject obj, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().getInt(obj, forceVolatile);
        }
        FieldStorageObject storageObject = this.getStorageObject(obj);
        if (forceVolatile) {
            return this.linkedField.getIntVolatile(storageObject);
        }
        return this.linkedField.getInt(storageObject);
    }

    @Override
    public void setInt(StaticObject obj, int value, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            this.getCompatibleField().setInt(obj, value, forceVolatile);
        } else {
            FieldStorageObject storageObject = this.getStorageObject(obj);
            if (forceVolatile) {
                this.linkedField.setIntVolatile(storageObject, value);
            } else {
                this.linkedField.setInt(storageObject, value);
            }
        }
    }

    @Override
    public boolean compareAndSwapInt(StaticObject obj, int before, int after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndSwapInt(obj, before, after);
        }
        return this.linkedField.compareAndSwapInt(this.getStorageObject(obj), before, after);
    }

    @Override
    public int compareAndExchangeInt(StaticObject obj, int before, int after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndExchangeInt(obj, before, after);
        }
        return this.linkedField.compareAndExchangeInt(this.getStorageObject(obj), before, after);
    }

    @Override
    public long getLong(StaticObject obj, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().getLong(obj, forceVolatile);
        }
        FieldStorageObject storageObject = this.getStorageObject(obj);
        if (forceVolatile) {
            return this.linkedField.getLongVolatile(storageObject);
        }
        return this.linkedField.getLong(storageObject);
    }

    @Override
    public void setLong(StaticObject obj, long value, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            this.getCompatibleField().setLong(obj, value, forceVolatile);
        } else {
            FieldStorageObject storageObject = this.getStorageObject(obj);
            if (forceVolatile) {
                this.linkedField.setLongVolatile(storageObject, value);
            } else {
                this.linkedField.setLong(storageObject, value);
            }
        }
    }

    @Override
    public boolean compareAndSwapLong(StaticObject obj, long before, long after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndSwapLong(obj, before, after);
        }
        return this.linkedField.compareAndSwapLong(this.getStorageObject(obj), before, after);
    }

    @Override
    public long compareAndExchangeLong(StaticObject obj, long before, long after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndExchangeLong(obj, before, after);
        }
        return this.linkedField.compareAndExchangeLong(this.getStorageObject(obj), before, after);
    }

    @Override
    public short getShort(StaticObject obj, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().getShort(obj, forceVolatile);
        }
        FieldStorageObject storageObject = this.getStorageObject(obj);
        if (forceVolatile) {
            return this.linkedField.getShortVolatile(storageObject);
        }
        return this.linkedField.getShort(storageObject);
    }

    @Override
    public void setShort(StaticObject obj, short value, boolean forceVolatile) {
        if (this.hasCompatibleField()) {
            this.getCompatibleField().setShort(obj, value, forceVolatile);
        } else {
            FieldStorageObject storageObject = this.getStorageObject(obj);
            if (forceVolatile) {
                this.linkedField.setShortVolatile(storageObject, value);
            } else {
                this.linkedField.setShort(storageObject, value);
            }
        }
    }

    @Override
    public boolean compareAndSwapShort(StaticObject obj, short before, short after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndSwapShort(obj, before, after);
        }
        return this.linkedField.compareAndSwapShort(this.getStorageObject(obj), before, after);
    }

    @Override
    public short compareAndExchangeShort(StaticObject obj, short before, short after) {
        if (this.hasCompatibleField()) {
            return this.getCompatibleField().compareAndExchangeShort(obj, before, after);
        }
        return this.linkedField.compareAndExchangeShort(this.getStorageObject(obj), before, after);
    }
}

