/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.api;

import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;

public final class CallFrame {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    public static final Object INVALID_VALUE = new Object();
    private final byte typeTag;
    private final long classId;
    private final MethodRef method;
    private final long methodId;
    private final long codeIndex;
    private final long threadId;
    private final Frame frame;
    private final Node currentNode;
    private final RootNode rootNode;
    private final DebugStackFrame debugStackFrame;
    private final DebugScope debugScope;
    private final JDWPContext context;
    private final DebuggerController controller;
    private Object scope;

    public CallFrame(long threadId, byte typeTag, long classId, MethodRef method, long methodId, long codeIndex, Frame frame, Node currentNode, RootNode rootNode, DebugStackFrame debugStackFrame, JDWPContext context, DebuggerController controller) {
        this.threadId = threadId;
        this.typeTag = typeTag;
        this.classId = classId;
        this.method = method;
        this.methodId = methodId;
        this.codeIndex = method != null && method.isObsolete() ? -1L : codeIndex;
        this.frame = frame;
        this.currentNode = currentNode;
        this.rootNode = rootNode;
        this.debugStackFrame = debugStackFrame;
        this.debugScope = debugStackFrame != null ? debugStackFrame.getScope() : null;
        this.context = context;
        this.controller = controller;
    }

    public CallFrame(long threadId, byte typeTag, long classId, long methodId, long codeIndex) {
        this(threadId, typeTag, classId, null, methodId, codeIndex, null, null, null, null, null, null);
    }

    public byte getTypeTag() {
        return this.typeTag;
    }

    public long getClassId() {
        return this.classId;
    }

    public MethodRef getMethod() {
        return this.method;
    }

    public long getMethodId() {
        if (this.method == null) {
            return this.methodId;
        }
        return this.method.isObsolete() ? 0L : this.methodId;
    }

    public long getCodeIndex() {
        return this.codeIndex;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }

    public Object getThisValue() {
        Object theScope = this.getScope();
        if (theScope == null) {
            return null;
        }
        try {
            if (INTEROP.isMemberReadable(theScope, "this")) {
                return INTEROP.readMember(theScope, "this");
            }
            return INTEROP.readMember(theScope, "0");
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            if (this.controller != null) {
                this.controller.warning(() -> "Unable to read 'this' value from method: " + this.getMethod() + " with currentNode: " + this.currentNode.getClass());
            }
            return INVALID_VALUE;
        }
    }

    public Object getVariable(String identifier) throws InteropException {
        Object theScope = this.getScope();
        return theScope != null ? INTEROP.readMember(theScope, identifier) : null;
    }

    public void setVariable(Object value, String identifier) {
        block3: {
            Object theScope = this.getScope();
            if (theScope == null) {
                return;
            }
            try {
                INTEROP.writeMember(theScope, identifier, value);
            }
            catch (Exception e) {
                if (this.controller == null) break block3;
                this.controller.warning(() -> "Unable to write member " + identifier + " from variables");
            }
        }
    }

    public DebugStackFrame getDebugStackFrame() {
        return this.debugStackFrame;
    }

    private Object getScope() {
        if (this.scope != null) {
            return this.scope;
        }
        Node node = InstrumentableNode.findInstrumentableParent((Node)this.currentNode);
        if (NodeLibrary.getUncached().hasScope((Object)node, this.frame)) {
            try {
                this.scope = NodeLibrary.getUncached().getScope((Object)node, this.frame, true);
            }
            catch (UnsupportedMessageException e) {
                if (this.controller != null) {
                    this.controller.warning(() -> "Unable to get scope for " + this.currentNode.getClass());
                }
            }
        } else if (this.controller != null) {
            this.controller.warning(() -> "Unable to get scope for " + this.currentNode.getClass());
        }
        return this.scope;
    }

    public DebugValue asDebugValue(Object returnValue) {
        assert (this.debugScope != null);
        return this.debugScope.convertRawValue(this.context.getLanguageClass(), returnValue);
    }
}

