/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jvmti;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.jvmti.JVMTIEnv;
import com.oracle.truffle.espresso.jvmti.JvmtiPhase;
import com.oracle.truffle.espresso.jvmti.JvmtiVersion;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.util.ArrayList;

public final class JVMTI {
    private final EspressoContext context;
    private final @Pointer TruffleObject initializeJvmtiContext;
    private final @Pointer TruffleObject disposeJvmtiContext;
    private final ArrayList<JVMTIEnv> activeEnvironments = new ArrayList();
    private JvmtiPhase phase;

    public JVMTI(EspressoContext context, TruffleObject mokapotLibrary) {
        this.context = context;
        this.initializeJvmtiContext = context.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "initializeJvmtiContext", NativeSignature.create(NativeType.POINTER, NativeType.POINTER, NativeType.INT));
        this.disposeJvmtiContext = context.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "disposeJvmtiContext", NativeSignature.create(NativeType.VOID, NativeType.POINTER, NativeType.INT, NativeType.POINTER));
    }

    public static boolean isJvmtiVersion(int version) {
        return JvmtiVersion.isJvmtiVersion(version);
    }

    private static boolean isSupportedJvmtiVersion(int version) {
        return JvmtiVersion.isSupportedJvmtiVersion(version);
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized TruffleObject create(int version) {
        if (!JVMTI.isSupportedJvmtiVersion(version)) {
            return null;
        }
        JVMTIEnv jvmtiEnv = new JVMTIEnv(this.context, this.initializeJvmtiContext, version);
        this.activeEnvironments.add(jvmtiEnv);
        return jvmtiEnv.getEnv();
    }

    public synchronized void dispose() {
        for (JVMTIEnv jvmtiEnv : this.activeEnvironments) {
            jvmtiEnv.dispose(this.disposeJvmtiContext);
        }
        this.activeEnvironments.clear();
    }

    @CompilerDirectives.TruffleBoundary
    synchronized void dispose(JVMTIEnv env) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.activeEnvironments.contains(env)) {
            env.dispose(this.disposeJvmtiContext);
            this.activeEnvironments.remove(env);
        }
    }

    public synchronized int getPhase() {
        return this.phase.value();
    }

    public synchronized void enterPhase(JvmtiPhase jvmtiPhase) {
        this.phase = jvmtiPhase;
    }

    public synchronized void postVmStart() {
        this.enterPhase(JvmtiPhase.START);
    }

    public synchronized void postVmInit() {
        this.enterPhase(JvmtiPhase.LIVE);
    }

    public synchronized void postVmDeath() {
        this.enterPhase(JvmtiPhase.DEAD);
    }
}

