/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jvmti;

class JvmtiVersion {
    private static final int JVMTI_VERSION_1 = 0x30010000;
    private static final int JVMTI_VERSION_1_0 = 0x30010000;
    private static final int JVMTI_VERSION_1_1 = 0x30010100;
    private static final int JVMTI_VERSION_1_2 = 805372416;
    private static final int JVMTI_VERSION_9 = 0x30090000;
    private static final int JVMTI_VERSION_11 = 0x300B0000;
    private static final int JVMTI_VERSION = 0x300B0000;
    private static final int JVMTI_VERSION_MASK = 0x70000000;
    private static final int JVMTI_VERSION_VALUE = 0x30000000;

    JvmtiVersion() {
    }

    public static boolean isJvmtiVersion(int version) {
        return (version & 0x70000000) == 0x30000000;
    }

    public static boolean isSupportedJvmtiVersion(int version) {
        return DecodedJVMTIVersion.decode(version).isSupported();
    }

    private static final class DecodedJVMTIVersion {
        private static final int JVMTI_VERSION_MASK_MAJOR = 0xFFF0000;
        private static final int JVMTI_VERSION_MASK_MINOR = 65280;
        private static final int JVMTI_VERSION_MASK_MICRO = 255;
        private static final int JVMTI_VERSION_SHIFT_MAJOR = 16;
        private static final int JVMTI_VERSION_SHIFT_MINOR = 8;
        private static final int JVMTI_VERSION_SHIFT_MICRO = 0;
        private final int major;
        private final int minor;
        private final int micro;

        DecodedJVMTIVersion(int major, int minor, int micro) {
            this.major = major;
            this.minor = minor;
            this.micro = micro;
        }

        static DecodedJVMTIVersion decode(int version) {
            return new DecodedJVMTIVersion((version & 0xFFF0000) >> 16, (version & 0xFF00) >> 8, (version & 0xFF) >> 0);
        }

        boolean isSupported() {
            if (this.major == 1) {
                return this.minor == 0 || this.minor == 1 || this.minor == 2;
            }
            if (this.major == 9) {
                return this.minor == 0;
            }
            if (this.major == 11) {
                return this.minor == 0;
            }
            return false;
        }
    }
}

