/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.meta;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.JavaVersion;

final class DiffVersionLoadHelper {
    private final Meta meta;
    private Symbol<Symbol.Name> name;
    private Symbol<Symbol.Type> type;
    private Symbol<Symbol.Signature> signature;

    DiffVersionLoadHelper(Meta meta) {
        this.meta = meta;
    }

    DiffVersionLoadHelper klass(JavaVersion.VersionRange range, Symbol<Symbol.Type> t) {
        if (range.contains(this.meta.getJavaVersion())) {
            this.type = t;
        }
        return this;
    }

    ObjectKlass klass() {
        if (this.type == null) {
            throw EspressoError.shouldNotReachHere();
        }
        return this.meta.knownKlass(this.type);
    }

    ObjectKlass notRequiredKlass() {
        if (this.type == null) {
            return null;
        }
        return this.meta.loadKlassWithBootClassLoader(this.type);
    }

    DiffVersionLoadHelper method(JavaVersion.VersionRange range, Symbol<Symbol.Name> n, Symbol<Symbol.Signature> s) {
        if (range.contains(this.meta.getJavaVersion())) {
            this.name = n;
            this.signature = s;
        }
        return this;
    }

    Method method(ObjectKlass klass) {
        if (this.name == null || this.signature == null) {
            throw EspressoError.shouldNotReachHere();
        }
        return klass.requireDeclaredMethod(this.name, this.signature);
    }

    Method notRequiredMethod(ObjectKlass klass) {
        if (this.name == null || this.signature == null) {
            return null;
        }
        if (klass == null) {
            return null;
        }
        return klass.lookupDeclaredMethod(this.name, this.signature);
    }

    DiffVersionLoadHelper field(JavaVersion.VersionRange range, Symbol<Symbol.Name> n, Symbol<Symbol.Type> t) {
        if (range.contains(this.meta.getJavaVersion())) {
            this.name = n;
            this.type = t;
        }
        return this;
    }

    Field field(ObjectKlass klass) {
        if (this.name == null || this.type == null) {
            throw EspressoError.shouldNotReachHere();
        }
        return klass.requireDeclaredField(this.name, this.type);
    }

    Field maybeHiddenfield(ObjectKlass klass) {
        if (this.name == null || this.type == null) {
            throw EspressoError.shouldNotReachHere();
        }
        Field f = klass.lookupDeclaredField(this.name, this.type);
        if (f == null) {
            return klass.requireHiddenField(this.name);
        }
        return f;
    }

    Field notRequiredField(ObjectKlass klass) {
        if (this.name == null || this.type == null) {
            return null;
        }
        if (klass == null) {
            return null;
        }
        return klass.lookupDeclaredField(this.name, this.type);
    }
}

