/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.analysis.hierarchy.AssumptionGuardedValue;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyAssumption;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.NullCheck;
import com.oracle.truffle.espresso.nodes.bytecodes.Utils;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="INVOKEVIRTUAL")
public abstract class InvokeVirtual
extends EspressoNode {
    final Method resolutionSeed;

    InvokeVirtual(Method resolutionSeed) {
        assert (resolutionSeed.getVTableIndex() >= 0);
        this.resolutionSeed = resolutionSeed;
    }

    protected abstract Object execute(Object[] var1);

    @Specialization
    Object doWithNullCheck(Object[] args, @Cached NullCheck nullCheck, @Cached(value="create(resolutionSeed)") WithoutNullCheck invokeVirtual) {
        StaticObject receiver = (StaticObject)args[0];
        nullCheck.execute(receiver);
        return invokeVirtual.execute(args);
    }

    static StaticObject getReceiver(Object[] args) {
        return (StaticObject)args[0];
    }

    static Method.MethodVersion methodLookup(Method resolutionSeed, Klass receiverKlass) {
        CompilerAsserts.neverPartOfCompilation();
        return InvokeVirtual.genericMethodLookup(receiverKlass.getContext(), resolutionSeed, receiverKlass, BranchProfile.getUncached());
    }

    static Method.MethodVersion genericMethodLookup(EspressoContext context, Method resolutionSeed, Klass receiverKlass, BranchProfile error) {
        if (resolutionSeed.isRemovedByRedefinition()) {
            return resolutionSeed.getContext().getClassRedefinition().handleRemovedMethod(resolutionSeed, receiverKlass).getMethodVersion();
        }
        int vtableIndex = resolutionSeed.getVTableIndex();
        Method.MethodVersion target = receiverKlass.isArray() ? receiverKlass.getSuperKlass().vtableLookup(vtableIndex).getMethodVersion() : receiverKlass.vtableLookup(vtableIndex).getMethodVersion();
        if (!target.getMethod().hasCode()) {
            error.enter();
            Meta meta = context.getMeta();
            throw meta.throwException(meta.java_lang_AbstractMethodError);
        }
        return target;
    }

    @NodeInfo(shortName="INVOKEVIRTUAL !nullcheck")
    @ImportStatic(value={InvokeVirtual.class, Utils.class})
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        final Method resolutionSeed;
        protected static final int LIMIT = 8;

        WithoutNullCheck(Method resolutionSeed) {
            assert (resolutionSeed.getVTableIndex() >= 0);
            this.resolutionSeed = resolutionSeed;
        }

        public abstract Object execute(Object[] var1);

        protected AssumptionGuardedValue<ObjectKlass> readSingleImplementor() {
            return this.getContext().getClassHierarchyOracle().readSingleImplementor(this.resolutionSeed.getDeclaringKlass());
        }

        protected ClassHierarchyAssumption readLeafAssumption() {
            return this.getContext().getClassHierarchyOracle().isLeafMethod(this.resolutionSeed.getMethodVersion());
        }

        @Specialization(assumptions={"maybeSingleImplementor.hasValue()", "resolvedMethod.getRedefineAssumption()"}, guards={"implementor != null"})
        Object callSingleImplementor(Object[] args, @Bind(value="getReceiver(args)") StaticObject receiver, @Cached(value="readSingleImplementor()") AssumptionGuardedValue<ObjectKlass> maybeSingleImplementor, @Cached(value="maybeSingleImplementor.get()") ObjectKlass implementor, @Cached(value="methodLookup(resolutionSeed, implementor)") Method.MethodVersion resolvedMethod, @Cached(value="create(resolvedMethod)") LazyDirectCallNode directCallNode) {
            assert (args[0] == receiver);
            assert (!StaticObject.isNull(receiver));
            return directCallNode.execute(args);
        }

        @Specialization(guards={"!resolutionSeed.isAbstract()", "resolvedMethod.getMethod() == resolutionSeed"}, assumptions={"readLeafAssumption().getAssumption()", "resolvedMethod.getRedefineAssumption()"})
        Object callLeafMethod(Object[] args, @Bind(value="getReceiver(args)") StaticObject receiver, @Cached(value="methodLookup(resolutionSeed, receiver.getKlass())") Method.MethodVersion resolvedMethod, @Cached(value="create(resolvedMethod)") LazyDirectCallNode directCallNode) {
            assert (args[0] == receiver);
            assert (!StaticObject.isNull(receiver));
            assert (resolvedMethod.getMethod() == this.resolutionSeed);
            return directCallNode.execute(args);
        }

        @Specialization(limit="LIMIT", replaces={"callSingleImplementor", "callLeafMethod"}, guards={"receiver.getKlass() == cachedKlass"}, assumptions={"resolvedMethod.getRedefineAssumption()"})
        Object callDirect(Object[] args, @Bind(value="getReceiver(args)") StaticObject receiver, @Cached(value="receiver.getKlass()") Klass cachedKlass, @Cached(value="methodLookup(resolutionSeed, cachedKlass)") Method.MethodVersion resolvedMethod, @Cached(value="createAndMaybeForceInline(resolvedMethod)") DirectCallNode directCallNode) {
            assert (args[0] == receiver);
            assert (!StaticObject.isNull(receiver));
            return directCallNode.call(args);
        }

        @Specialization
        @ReportPolymorphism.Megamorphic
        Object callIndirect(Object[] args, @Cached BranchProfile error, @Cached IndirectCallNode indirectCallNode) {
            StaticObject receiver = (StaticObject)args[0];
            assert (args[0] == receiver);
            assert (!StaticObject.isNull(receiver));
            Method.MethodVersion target = InvokeVirtual.genericMethodLookup(this.getContext(), this.resolutionSeed, receiver.getKlass(), error);
            return indirectCallNode.call(target.getCallTarget(), args);
        }

        @ImportStatic(value={Utils.class})
        static abstract class LazyDirectCallNode
        extends EspressoNode {
            final Method.MethodVersion resolvedMethod;

            LazyDirectCallNode(Method.MethodVersion resolvedMethod) {
                this.resolvedMethod = resolvedMethod;
            }

            public abstract Object execute(Object[] var1);

            @Specialization
            Object doCached(Object[] args, @Cached(value="createAndMaybeForceInline(resolvedMethod)") DirectCallNode directCallNode) {
                return directCallNode.call(args);
            }
        }
    }

    @NodeInfo(shortName="INVOKEVIRTUAL dynamic")
    @GenerateUncached
    public static abstract class Dynamic
    extends EspressoNode {
        protected static final int LIMIT = 4;

        public abstract Object execute(Method var1, Object[] var2);

        @Specialization
        Object doWithNullCheck(Method resolutionSeed, Object[] args, @Cached NullCheck nullCheck, @Cached WithoutNullCheck invokeVirtual) {
            StaticObject receiver = (StaticObject)args[0];
            nullCheck.execute(receiver);
            return invokeVirtual.execute(resolutionSeed, args);
        }

        @NodeInfo(shortName="INVOKEVIRTUAL dynamic !nullcheck")
        @GenerateUncached
        public static abstract class WithoutNullCheck
        extends EspressoNode {
            protected static final int LIMIT = 4;

            public abstract Object execute(Method var1, Object[] var2);

            @Specialization(limit="LIMIT", guards={"resolutionSeed == cachedResolutionSeed"})
            Object doCached(Method resolutionSeed, Object[] args, @Cached(value="resolutionSeed") Method cachedResolutionSeed, @Cached(value="create(cachedResolutionSeed)") com.oracle.truffle.espresso.nodes.bytecodes.InvokeVirtual$WithoutNullCheck invokeVirtual) {
                StaticObject receiver = (StaticObject)args[0];
                assert (!StaticObject.isNull(receiver));
                return invokeVirtual.execute(args);
            }

            @Specialization(replaces={"doCached"})
            @ReportPolymorphism.Megamorphic
            Object doGeneric(Method resolutionSeed, Object[] args, @Cached BranchProfile error, @Cached IndirectCallNode indirectCallNode) {
                StaticObject receiver = (StaticObject)args[0];
                assert (!StaticObject.isNull(receiver));
                Method.MethodVersion target = InvokeVirtual.genericMethodLookup(this.getContext(), resolutionSeed, receiver.getKlass(), error);
                return indirectCallNode.call(target.getCallTarget(), args);
            }
        }
    }
}

