/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.ProxyKlass;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public class WrappedProxyKlass
extends ProxyKlass {
    private final EspressoContext context;
    private final Field foreignWrapperField;

    public WrappedProxyKlass(ObjectKlass proxyKlass, EspressoContext context, ObjectKlass superKlass) {
        super(proxyKlass);
        this.context = context;
        this.foreignWrapperField = this.getForeignWrapperField(superKlass);
    }

    private Field getForeignWrapperField(ObjectKlass superKlass) {
        if (superKlass == this.context.getMeta().polyglot.EspressoForeignList) {
            return this.context.getMeta().polyglot.EspressoForeignList_foreignObject;
        }
        throw EspressoError.shouldNotReachHere();
    }

    @Override
    public StaticObject createProxyInstance(Object foreignObject, EspressoLanguage language, InteropLibrary interop) {
        Meta meta = this.context.getMeta();
        StaticObject foreign = StaticObject.createForeign(language, meta.java_lang_Object, foreignObject, interop);
        StaticObject guestObject = this.context.getAllocator().createNew(this.getProxyKlass());
        this.foreignWrapperField.setObject(guestObject, foreign);
        return guestObject;
    }
}

