/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.preinit;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ClassLoadingEnv;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.ParserKlass;
import com.oracle.truffle.espresso.preinit.AbstractCachedKlassProvider;
import com.oracle.truffle.espresso.preinit.ParserKlassProvider;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.verifier.MethodVerifier;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class CachedParserKlassProvider
extends AbstractCachedKlassProvider
implements ParserKlassProvider {
    private final ParserKlassProvider fallbackProvider;
    private final Map<Symbol<Symbol.Type>, ParserKlass> bootParserKlassCache = new ConcurrentHashMap<Symbol<Symbol.Type>, ParserKlass>();
    private final Map<ParserKlassCacheKey, ParserKlass> appParserKlassCache = new ConcurrentHashMap<ParserKlassCacheKey, ParserKlass>();

    public CachedParserKlassProvider(TruffleLogger logger, ParserKlassProvider fallbackProvider) {
        super(logger);
        this.fallbackProvider = fallbackProvider;
    }

    @Override
    public ParserKlass getParserKlass(ClassLoadingEnv env, StaticObject loader, Symbol<Symbol.Type> typeOrNull, byte[] bytes, ClassRegistry.ClassDefinitionInfo info) {
        if (env.shouldCacheClass(info, loader) && typeOrNull != null) {
            ParserKlassCacheKey key = null;
            ParserKlass parserKlass = null;
            boolean loaderIsBootOrPlatform = env.loaderIsBootOrPlatform(loader);
            boolean loaderIsApp = env.loaderIsAppLoader(loader);
            if (loaderIsBootOrPlatform) {
                parserKlass = this.bootParserKlassCache.get(typeOrNull);
            } else if (loaderIsApp) {
                boolean verifiable = MethodVerifier.needsVerify(env.getLanguage(), loader);
                assert (!info.isAnonymousClass() && !info.isHidden() && info.patches == null);
                key = new ParserKlassCacheKey(bytes, typeOrNull, verifiable);
                parserKlass = this.appParserKlassCache.get(key);
            }
            if (parserKlass == null) {
                this.getLogger().finer(() -> "ParserKlass cache miss: " + typeOrNull);
                parserKlass = this.fallbackProvider.getParserKlass(env, loader, typeOrNull, bytes, info);
                if (loaderIsBootOrPlatform) {
                    this.bootParserKlassCache.put(typeOrNull, parserKlass);
                } else if (loaderIsApp) {
                    this.appParserKlassCache.put(key, parserKlass);
                }
            } else {
                ParserKlass finalParserKlass = parserKlass;
                this.getLogger().finer(() -> "ParserKlass cache hit: " + finalParserKlass.getName());
            }
            return parserKlass;
        }
        return this.fallbackProvider.getParserKlass(env, loader, typeOrNull, bytes, info);
    }

    @Override
    public int getCachedParserKlassCount() {
        return this.bootParserKlassCache.size() + this.appParserKlassCache.size();
    }

    private static final class ParserKlassCacheKey {
        private final byte[] bytes;
        private final int hash;
        private final Symbol<Symbol.Type> type;
        private final boolean verifiable;

        ParserKlassCacheKey(byte[] bytes, Symbol<Symbol.Type> type, boolean verifiable) {
            this.bytes = bytes;
            this.type = type;
            this.verifiable = verifiable;
            this.hash = ParserKlassCacheKey.computeHash(bytes, type, verifiable);
        }

        private static int computeHash(byte[] bytes, Symbol<Symbol.Type> typeOrNull, boolean verifiable) {
            int result = Arrays.hashCode(bytes);
            result = 31 * result + typeOrNull.hashCode();
            result = 31 * result + Boolean.hashCode(verifiable);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParserKlassCacheKey other = (ParserKlassCacheKey)o;
            if (this.hash != other.hash) {
                return false;
            }
            return Arrays.equals(this.bytes, other.bytes) && this.type.equals(other.type) && this.verifiable == other.verifiable;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

