/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.methodhandle.MHInvokeBasicNodeGen;
import com.oracle.truffle.espresso.nodes.methodhandle.MHInvokeGenericNode;
import com.oracle.truffle.espresso.nodes.methodhandle.MHLinkToNativeNode;
import com.oracle.truffle.espresso.nodes.methodhandle.MHLinkToNodeGen;
import com.oracle.truffle.espresso.nodes.methodhandle.MethodHandleIntrinsicNode;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class MethodHandleIntrinsics {
    private final ConcurrentHashMap<MethodRef, Method> intrinsics = new ConcurrentHashMap();

    MethodHandleIntrinsics() {
    }

    public static MethodHandleIntrinsicNode createIntrinsicNode(EspressoLanguage language, Meta meta, Method method, Klass accessingKlass, Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature) {
        PolySigIntrinsics id = MethodHandleIntrinsics.getId(method);
        return switch (id) {
            default -> throw new IncompatibleClassChangeError();
            case PolySigIntrinsics.InvokeBasic -> MHInvokeBasicNodeGen.create(method);
            case PolySigIntrinsics.InvokeGeneric -> MHInvokeGenericNode.create(language, meta, accessingKlass, method, methodName, signature);
            case PolySigIntrinsics.LinkToVirtual, PolySigIntrinsics.LinkToStatic, PolySigIntrinsics.LinkToSpecial, PolySigIntrinsics.LinkToInterface -> MHLinkToNodeGen.create(method, id);
            case PolySigIntrinsics.LinkToNative -> MHLinkToNativeNode.create(method, meta);
            case PolySigIntrinsics.None -> throw EspressoError.shouldNotReachHere();
        };
    }

    public Method findIntrinsic(Method thisMethod, Symbol<Symbol.Signature> signature) {
        return this.findIntrinsic(thisMethod, new MethodRef(thisMethod, signature));
    }

    public static boolean isMethodHandleIntrinsic(Method m) {
        PolySigIntrinsics id = MethodHandleIntrinsics.getId(m);
        return id.isSignaturePolymorphic();
    }

    public static PolySigIntrinsics getId(Method m) {
        return MethodHandleIntrinsics.getId(m.getName(), m.getDeclaringKlass());
    }

    public static PolySigIntrinsics getId(Symbol<Symbol.Name> name, Klass declaringKlass) {
        if (!Symbol.Type.java_lang_invoke_MethodHandle.equals(declaringKlass.getType()) && !Symbol.Type.java_lang_invoke_VarHandle.equals(declaringKlass.getType())) {
            return PolySigIntrinsics.None;
        }
        if (Symbol.Type.java_lang_invoke_MethodHandle.equals(declaringKlass.getType())) {
            if (name == Symbol.Name.linkToStatic) {
                return PolySigIntrinsics.LinkToStatic;
            }
            if (name == Symbol.Name.linkToVirtual) {
                return PolySigIntrinsics.LinkToVirtual;
            }
            if (name == Symbol.Name.linkToSpecial) {
                return PolySigIntrinsics.LinkToSpecial;
            }
            if (name == Symbol.Name.linkToInterface) {
                return PolySigIntrinsics.LinkToInterface;
            }
            if (name == Symbol.Name.linkToNative) {
                return PolySigIntrinsics.LinkToNative;
            }
            if (name == Symbol.Name.invokeBasic) {
                return PolySigIntrinsics.InvokeBasic;
            }
        }
        if (declaringKlass.lookupPolysignatureDeclaredMethod(name, Klass.LookupMode.INSTANCE_ONLY) != null) {
            return PolySigIntrinsics.InvokeGeneric;
        }
        return PolySigIntrinsics.None;
    }

    private Method findIntrinsic(Method m, MethodRef methodRef) {
        Method method = this.getIntrinsic(methodRef);
        if (method != null) {
            return method;
        }
        CompilerAsserts.neverPartOfCompilation();
        method = m.createIntrinsic(methodRef.signature);
        Method previous = this.putIntrinsic(methodRef, method);
        if (previous != null) {
            return previous;
        }
        return method;
    }

    private Method getIntrinsic(MethodRef methodRef) {
        return this.intrinsics.get(methodRef);
    }

    private Method putIntrinsic(MethodRef methodRef, Method m) {
        return this.intrinsics.putIfAbsent(methodRef, m);
    }

    public static enum PolySigIntrinsics {
        None(false, false),
        InvokeGeneric(false, false),
        InvokeBasic(false, true),
        LinkToVirtual(true, true),
        LinkToStatic(true, true),
        LinkToSpecial(true, true),
        LinkToInterface(true, true),
        LinkToNative(true, true);

        public final boolean isSignaturePolymorphicIntrinsic;
        public final boolean isStatic;

        private PolySigIntrinsics(boolean isStatic, boolean isSignaturePolymorphic) {
            this.isStatic = isStatic;
            this.isSignaturePolymorphicIntrinsic = isSignaturePolymorphic;
        }

        public final boolean isStaticPolymorphicSignature() {
            return this.isStatic;
        }

        public final boolean isSignaturePolymorphicIntrinsic() {
            return this.isSignaturePolymorphicIntrinsic;
        }

        private boolean isSignaturePolymorphic() {
            return this != None;
        }
    }

    private static final class MethodRef {
        private final Symbol<Symbol.Type> clazz;
        private final Symbol<Symbol.Name> methodName;
        private final Symbol<Symbol.Signature> signature;
        private final int hash;

        MethodRef(Method m, Symbol<Symbol.Signature> signature) {
            this.clazz = m.getDeclaringKlass().getType();
            this.methodName = m.getName();
            this.signature = signature;
            this.hash = Objects.hash(this.clazz, this.methodName, signature);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MethodRef other = (MethodRef)obj;
            return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.methodName, other.methodName) && Objects.equals(this.signature, other.signature);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return Types.binaryName(this.clazz) + "#" + this.methodName + this.signature;
        }
    }
}

