/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.espresso.runtime.PlatformBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.home.HomeFinder;

final class WindowsBuilder
extends PlatformBuilder {
    private final Path windowsRoot = Paths.get(System.getenv("SystemRoot"), new String[0]);
    private static final Path PACKAGE_DIR = Paths.get("Sun", "Java");

    WindowsBuilder(Path espressoLibs) {
        super(espressoLibs);
    }

    @Override
    List<Path> defaultJavaLibraryPath() {
        ArrayList<Path> libraryPath = new ArrayList<Path>();
        libraryPath.add(this.javaHome().resolve("bin"));
        libraryPath.add(this.windowsRoot.resolve(PACKAGE_DIR).resolve("bin"));
        libraryPath.add(this.windowsRoot.resolve("system32"));
        libraryPath.add(this.windowsRoot);
        WindowsBuilder.expandEnvToPath("PATH", libraryPath);
        libraryPath.add(Paths.get(".", new String[0]));
        return libraryPath;
    }

    @Override
    List<Path> defaultBootLibraryPath() {
        return Collections.singletonList(this.javaHome().resolve("bin"));
    }

    @Override
    List<Path> defaultJvmLibraryPath() {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path graalvmHome = HomeFinder.getInstance().getHomeFolder();
        if (graalvmHome != null && Files.isDirectory(graalvmHome, new LinkOption[0])) {
            paths.add(graalvmHome.resolve("bin").resolve("truffle"));
        }
        paths.add(this.espressoLibs());
        return paths;
    }

    @Override
    List<Path> defaultExtDirs() {
        return Arrays.asList(this.javaHome().resolve(EXTENSIONS_DIR), this.windowsRoot.resolve(PACKAGE_DIR).resolve(EXTENSIONS_DIR));
    }
}

