/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.messages;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.InteropKlassesDispatch;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageRootNode;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodesCollector;

public final class InteropMessageFactories {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final InteropMessageFactory[] messages = new InteropMessageFactory[10 * InteropMessage.Message.MESSAGE_COUNT];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final boolean[] isShareable = new boolean[10 * InteropMessage.Message.MESSAGE_COUNT];

    private InteropMessageFactories() {
    }

    public static void register(Class<?> cls, InteropMessage.Message message, InteropMessageFactory factory, boolean shareable) {
        assert (cls != null);
        assert (message != null);
        assert (factory != null);
        int index = InteropMessageFactories.getIndex(cls, message);
        if (messages[index] == null) {
            InteropMessageFactories.messages[index] = factory;
        }
        if (shareable) {
            InteropMessageFactories.isShareable[index] = true;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static CallTarget createInteropMessageTarget(EspressoLanguage lang, int id, InteropMessage.Message message) {
        int index = InteropMessageFactories.getIndex(id, message);
        InteropMessageFactory factory = messages[index];
        if (factory == null) {
            return null;
        }
        InteropMessage interopMessage = factory.create(message);
        return new InteropMessageRootNode(lang, interopMessage).getCallTarget();
    }

    public static boolean isShareable(int dispatchId, InteropMessage.Message message) {
        int index = InteropMessageFactories.getIndex(dispatchId, message);
        return isShareable[index];
    }

    public static int sourceDispatch(int dispatchId, InteropMessage.Message message) {
        assert (InteropMessageFactories.isShareable(dispatchId, message));
        int index = InteropMessageFactories.getIndex(dispatchId, message);
        return messages[index].sourceDispatch();
    }

    public static int getIndex(int dispatchId, InteropMessage.Message message) {
        int messageId = message.ordinal();
        return InteropMessage.Message.MESSAGE_COUNT * dispatchId + messageId;
    }

    public static int dispatchToId(Class<?> cls) {
        return InteropKlassesDispatch.dispatchToId(cls);
    }

    private static int getIndex(Class<?> cls, InteropMessage.Message message) {
        return InteropMessageFactories.getIndex(InteropMessageFactories.dispatchToId(cls), message);
    }

    static {
        for (InteropNodes nodes : InteropNodesCollector.getInstances(InteropNodes.class)) {
            nodes.register();
        }
    }
}

