/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.jimage.decompressor;

import com.oracle.truffle.espresso.runtime.jimage.BasicImageReader;
import com.oracle.truffle.espresso.runtime.jimage.decompressor.CompressedIndexes;
import com.oracle.truffle.espresso.runtime.jimage.decompressor.ResourceDecompressor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class StringSharingDecompressor
implements ResourceDecompressor {
    public static final String NAME = "compact-cp";
    public static final int EXTERNALIZED_STRING = 23;
    public static final int EXTERNALIZED_STRING_DESCRIPTOR = 25;

    private static void transfert(ByteBuffer from, ByteBuffer to, int len) {
        ByteBuffer dup = from.duplicate();
        int newFromPosition = from.position() + len;
        dup.limit(newFromPosition);
        to.put(dup);
        from.position(newFromPosition);
    }

    private static void transfert(ByteBuffer from, int fromPosition, ByteBuffer to, int len) {
        ByteBuffer dup = from.duplicate();
        dup.position(fromPosition);
        dup.limit(dup.position() + len);
        to.put(dup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer normalize(ResourceDecompressor.StringsProvider provider, ByteBuffer input, int originalSize) {
        ByteBuffer output = ByteBuffer.allocate(originalSize).order(ByteOrder.BIG_ENDIAN);
        ByteOrder originalOrder = input.order();
        input.order(ByteOrder.BIG_ENDIAN);
        try {
            output.putLong(input.getLong());
            int count = input.getChar();
            output.putChar((char)count);
            block12: for (int i = 1; i < count; ++i) {
                byte tag = input.get();
                switch (tag) {
                    case 1: {
                        output.put(tag);
                        char len = input.getChar();
                        output.putChar(len);
                        StringSharingDecompressor.transfert(input, output, len);
                        continue block12;
                    }
                    case 23: {
                        int index = CompressedIndexes.readInt(input);
                        ByteBuffer orig = provider.getRawString(index);
                        output.put((byte)1);
                        output.putChar((char)orig.remaining());
                        output.put(orig);
                        continue block12;
                    }
                    case 25: {
                        output.put((byte)1);
                        int lengthMark = output.position();
                        output.position(lengthMark + 2);
                        StringSharingDecompressor.reconstruct(provider, input, output);
                        int length = output.position() - lengthMark - 2;
                        output.putChar(lengthMark, (char)length);
                        continue block12;
                    }
                    case 5: 
                    case 6: {
                        ++i;
                        output.put(tag);
                        output.putLong(input.getLong());
                        continue block12;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 18: {
                        output.put(tag);
                        output.putInt(input.getInt());
                        continue block12;
                    }
                    case 15: {
                        output.put(tag);
                        output.put(input.get());
                        output.put(input.get());
                        output.put(input.get());
                        continue block12;
                    }
                    case 7: 
                    case 8: 
                    case 16: 
                    case 19: 
                    case 20: {
                        output.put(tag);
                        output.putShort(input.getShort());
                        continue block12;
                    }
                    default: {
                        throw new RuntimeException("Unexpected tag: " + (tag & 0xFF));
                    }
                }
            }
        }
        finally {
            input.order(originalOrder);
        }
        output.order(originalOrder);
        output.put(input);
        if (output.hasRemaining()) {
            BasicImageReader.LOGGER.warning("StringSharingDecompressor output was smaller than expected: " + output.remaining() + "bytes of output remaining");
        }
        return output.flip();
    }

    private static void reconstruct(ResourceDecompressor.StringsProvider reader, ByteBuffer input, ByteBuffer output) {
        ByteBuffer desc = reader.getRawString(CompressedIndexes.readInt(input));
        int indiciesLimit = CompressedIndexes.readInt(input) + input.position();
        if (indiciesLimit > input.limit()) {
            throw new RuntimeException("Indices larger than input");
        }
        int runStart = desc.position();
        for (int i = desc.position(); i < desc.limit(); ++i) {
            byte c = desc.get(i);
            if (c != 76) continue;
            int runLength = i - runStart;
            if (runLength > 0) {
                StringSharingDecompressor.transfert(desc, runStart, output, runLength);
            }
            runStart = i + 1;
            ByteBuffer pkg = reader.getRawString(CompressedIndexes.readInt(input));
            ByteBuffer clazz = reader.getRawString(CompressedIndexes.readInt(input));
            if (input.position() > indiciesLimit) {
                throw new RuntimeException("Missing indicies");
            }
            output.put((byte)76);
            if (pkg.hasRemaining()) {
                output.put(pkg);
                output.put((byte)47);
            }
            output.put(clazz);
        }
        if (runStart < desc.limit()) {
            int runLength = desc.limit() - runStart;
            StringSharingDecompressor.transfert(desc, runStart, output, runLength);
        }
        if (input.position() < indiciesLimit) {
            BasicImageReader.LOGGER.warning("StringSharingDecompressor: " + (indiciesLimit - input.position()) + " indicies bytes remain unused after reconstructing descriptor");
            input.position(indiciesLimit);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ByteBuffer decompress(ResourceDecompressor.StringsProvider reader, ByteBuffer content, long originalSize) {
        return StringSharingDecompressor.normalize(reader, content, Math.toIntExact(originalSize));
    }
}

